package com.valor.vod.cloud.mfcusercloud;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class GuavaCache {
    private static final Logger logger = LoggerFactory.getLogger(GuavaCache.class);
    private static ScheduledExecutorService clearExecutor = Executors.newScheduledThreadPool(8);
    Cache<String,Object> guavaCache = null;

    private long statSeconds = 300;
    private long metricSeconds = 60;
    private String cacheName;
    private Long maximumSize = 0L;

    public GuavaCache(
        String cacheName
        , long expireSeconds
        , long maximumSize
    ){
        this.cacheName = cacheName;
        this.maximumSize = maximumSize;
        if (maximumSize == 0){
            guavaCache = CacheBuilder.newBuilder()
                .recordStats()
                .expireAfterWrite(expireSeconds,TimeUnit.SECONDS)
                .build();
        }
        else {
            guavaCache = CacheBuilder.newBuilder()
                .recordStats()
                .expireAfterWrite(expireSeconds,TimeUnit.SECONDS)
                .maximumSize(maximumSize)
                .build();
        }

        clearExecutor.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                try {
                    guavaCache.cleanUp();
                }
                catch (Exception ex){}
            }
        }, 0, 4, TimeUnit.HOURS);

    }


    public void del(String key) {
        try {
            guavaCache.invalidate(key);
        }
        catch (Exception ex){
            logger.error("del(),exception:{}",ex);
        }
    }

    public Boolean exists(String key) {
        try {
            return guavaCache.asMap().containsKey(key);
        }
        catch (Exception ex){
            logger.error("del(),exception:{}",ex);
            return null;
        }
    }

//    @Override
//    public <V> V get(String key) {
//        try {
//            Object obj = guavaCache.getIfPresent(key);
//            return (V)obj;
//        }
//        catch (Exception ex){
//            logger.error("get(),exception:{}",ex);
//            return null;
//        }
//    }

    public <V> V get(String key) {
        try {
            Optional<V> optObj = (Optional<V>)guavaCache.getIfPresent(key);
            if (optObj == null){
                return null;
            }
            else{
                if (optObj.isPresent()){
                    return optObj.get();
                }
                else{
                    return null;
                }
            }
        }
        catch (Exception ex){
            logger.error("get(),exception:{}",ex);
            return null;
        }
    }

//    @Override
//    public <V> void set(String key, V value) {
//        try {
//            guavaCache.put(key,value);
//        }
//        catch (Exception ex){
//            logger.error("set(),exception:{}",ex);
//        }
//    }

    public <V> void set(String key, V value) {
        try {
            Optional<V> optValue = Optional.ofNullable(value);
            guavaCache.put(key,optValue);
        }
        catch (Exception ex){
            logger.error("set(),exception:{}",ex);
        }
    }

    public <V> List<V> mGet(String[] keys) {
        try {
            List<V> results = new ArrayList<>();
            for (int i=0;i<keys.length;i++){
                String key = keys[i];
                Optional<V> optObj = (Optional<V>)guavaCache.getIfPresent(key);
                V obj = null;
                if (optObj == null){
                    obj = null;
                }
                else{
                    if (optObj.isPresent()){
                        obj = optObj.get();
                    }
                    else{
                        obj = null;
                    }
                }
                results.add(obj);
            }
            return results;
        }
        catch (Exception ex){
            logger.error("mGet(),exception:{}",ex);
            return null;
        }
    }

    public <V> void mSet(Map<String, V> keyValueMap){
        try {
            for (Map.Entry<String,V> e:keyValueMap.entrySet()){
                Optional<V> optValue = Optional.ofNullable(e.getValue());
                guavaCache.put(e.getKey(),optValue);
            }
        }
        catch (Exception ex){
            logger.error("mSet(),exception:{}",ex);
        }
    }

    public Set<String> keys() {
        try {
            return guavaCache.asMap().keySet();
        }
        catch (Exception ex){
            logger.error("keys(),exception:{}",ex);
            return null;
        }
    }



}
