package com.valor.vod.cloud.model.database.dao;


import com.valor.vod.common.database.tool.access.SqlScalars;
import com.valor.vod.common.database.tool.access.constants.EOperator;
import com.valor.vod.common.database.tool.access.constants.ESqlOrder;
import org.hibernate.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

//@Repository
@Transactional(value = "cloudTransactionManager")
public class CloudBaseDao extends AbstractCloudBaseDao{
    @Autowired
    protected SessionFactory cloudSessionFactory;

    public CloudBaseDao() {
    }

    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    public Session openTenantSession(String schemaName) {
        return this.cloudSessionFactory.withOptions().tenantIdentifier(schemaName).openSession();
    }
    public void closeSession(Session session){
        if (session != null){
            return;
        }
        session.close();
    }

    public void flushAndClear() {
        super.flushAndClear();
    }

    public void storeEntity(Object entity) {
        super.storeEntity(entity);
    }

    public void storeEntityIfAbsent(Object entity) {
        super.storeEntityIfAbsent(entity);
    }

    public Object mergeEntity(Object entity) {
        return super.mergeEntity(entity);
    }

    public void mergeAll(Collection entities) {
        super.mergeAll(entities);
    }

    public void storeAll(Collection entities) {
        super.storeAll(entities);
    }

    public void storeAllIfAbsent(Collection entities) {
        super.storeAllIfAbsent(entities);
    }

    public void deleteAll(Collection entities) {
        super.deleteAll(entities);
    }

    public void saveEntity(Object entity) {
        super.saveEntity(entity);
    }

    public void updateEntity(Object entity) {
        super.updateEntity(entity);
    }

    public void deleteEntity(Object entity) {
        super.deleteEntity(entity);
    }

    public List find(CharSequence queryString) {
       return super.find(queryString);
    }

    public List findById(CharSequence queryString, Long id) {
       return super.findById(queryString,id);
    }

    public List findByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
       return super.findByNamedParameters(queryCharSequence,params);
    }

    public Object findUniqueByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
        return super.findUniqueByNamedParameters(queryCharSequence,params);
    }

    public int executeUpdate(CharSequence queryCharSequence) {
        return super.executeUpdate(queryCharSequence);
    }

    public int executeUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        return super.executeUpdate(queryCharSequence,params);
    }

    public int executeSqlUpdate(CharSequence queryCharSequence) {
        return super.executeSqlUpdate(queryCharSequence);
    }


    public int executeSqlUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        return super.executeSqlUpdate(queryCharSequence,params);
    }

    public <T> List<T> query(Class T, SqlScalars sqlScalars, int firstResult, int maxResult) {
        return super.query(T,sqlScalars,firstResult,maxResult);
    }

    public <T> List<T> query(Class T, SqlScalars sqlScalars, boolean cacheable) {
        return super.query(T,sqlScalars,cacheable);
    }

    public List getDataList(boolean enableCache, Class returnType, Map<EOperator, Map<String, Object>> filters) {
        return super.getDataList(enableCache,returnType,filters);
    }

    public List getListData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return super.getListData(enableCache,returnType,filters);
    }

    public List getListDataIn(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return super.getListDataIn(enableCache,returnType,filters);
    }

    public Set getSetData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return super.getSetData(enableCache,returnType,filters);
    }

    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        return super.getData(enableCahce,returnType,filters);
    }

    public int excuteSql(String sql) {
        return super.excuteSql(sql);
    }

    public List<Object[]> excuteSql2(String sql) {
        return super.excuteSql2(sql);
    }

    public int excuteQueryCount(String sql) {
        return super.excuteQueryCount(sql);
    }

    public long criteriaQueryCount(Class valueType) {
        return super.criteriaQueryCount(valueType);
    }

    public long criteriaQueryCount(Class valueType, boolean cacheable) {
        return super.criteriaQueryCount(valueType,cacheable);
    }

    public long criteriaQueryCount(Class valueType, Map<String, Object> filter) {
        return super.criteriaQueryCount(valueType,filter);
    }

    public List getPageData(Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        return super.getPageData(returnType,filters,order,firstResult,maxResult);
    }

    public List getPageData(boolean cacheable, Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        return super.getPageData(cacheable,returnType,filters,order,firstResult,maxResult);
    }

    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateTime(clazz,filters);
    }

    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateDate(clazz,filters);
    }

    public long getLatestUpdateTS(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateTS(clazz,filters);
    }

    public String queryDBStamp(Class clazz, String lastUpdateField) {
        return super.queryDBStamp(clazz,lastUpdateField);
    }

    public void storeAllNoRepeat(Collection entities) {
        super.storeAllNoRepeat(entities);
    }
}
