package com.valor.vod.cloud.model.database.ddo;


import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

@Entity
@Table(
    name = "share_cloud_detail", indexes = {
    @Index(name = "i_share_cloud_share_id", columnList = "share_id")
    , @Index(name = "i_share_cloud_entity", columnList = "entity_id,entity_type")
}
)
public class ShareCloudDetailDdo extends TenantAbstractLMI {

    @Id
    @Column(name = "share_id")
    private long shareId;

    @Id
    // pkgId or cid
    @Column(name = "entity_id")
    private long entityId;

    @Id
    // 0:cid 1:pkgId
    @Column(name = "entity_type")
    private int entityType;

    @Column(name = "alias")
    private String alias;

    public long getShareId() {
        return shareId;
    }

    public void setShareId(long shareId) {
        this.shareId = shareId;
    }

    public long getEntityId() {
        return entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public int getEntityType() {
        return entityType;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}
