package com.valor.vod.cloud.usercloud;

import com.valor.vod.api.common.ListTool;
import com.valor.vod.api.model.cloud.ECloudAcctType;
import com.valor.vod.cloud.mfcusercloud.MfcUserCloudService;
import com.valor.vod.cloud.mfcusercloud.UserCloudCidSummary;
import com.valor.vod.cloud.model.database.ddo.PublicCloudConfigDdo;
import com.valor.vod.cloud.model.database.ddo.UserCloudDdo;
import com.valor.vod.cloud.model.database.ddo.UserPublicCloudDdo;
import com.valor.vod.cloud.model.database.ddo.VendorCloudDdo;
import com.valor.vod.common.cache.redis.MFCRedisUtil;
import com.valor.vod.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class UserCloudService {
    private static final Logger logger = LoggerFactory.getLogger(UserCloudService.class);
    @Autowired
    MfcUserCloudService mfcUserCloudService;

    public Set<Long> getUserCloudIds(Long accountId) {
        //获取用户的网盘ID集合
        Map<Long, UserCloudCidSummary> cidSummarys =  mfcUserCloudService.getCidSummaryByAccount(accountId);
        if (CollectionUtils.isNullOrEmpty(cidSummarys)) {
            return Collections.emptySet();
        }
        return cidSummarys.keySet();
    }


}
