/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.cache;

import com.valor.vod.cloud.condition.CloudRedisClusterConnectionConditon;
import com.valor.vod.cloud.condition.CloudRedisSingleConnectionCondition;
import com.valor.vod.common.cache.redis.FastJsonRedisSerializer;
import common.config.tools.config.ConfigTools3;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import io.lettuce.core.resource.Delay;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class CloudCacheRedisConfig {
    private static final Logger log = LoggerFactory.getLogger(CloudCacheRedisConfig.class);
    int dbIndex = ConfigTools3.getInt((String)"mfc.cloud.redis.database", (Integer)0);
    String host = ConfigTools3.getString((String)"mfc.cloud.redis.host", (String)"");
    int port = ConfigTools3.getInt((String)"mfc.cloud.redis.port", (Integer)0);
    String password = ConfigTools3.getString((String)"mfc.cloud.redis.password", (String)"");
    long connectTimeout = ConfigTools3.getLong((String)"mfc.cloud.redis.connectTimeout", (Long)100L);
    long fixedTimeout = ConfigTools3.getLong((String)"mfc.cloud.redis.fixedTimeout", (Long)5L);

    @Bean(name={"cloudRedisConnectionFactory"})
    @Conditional(value={CloudRedisSingleConnectionCondition.class})
    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.createRedisConnectionFactory(this.dbIndex, this.host, this.port, this.password, this.connectTimeout, this.fixedTimeout);
    }

    @Bean(name={"cloudRedisConnectionFactory"})
    @Conditional(value={CloudRedisClusterConnectionConditon.class})
    public RedisConnectionFactory getClusterRedisConnectionFactory() {
        return this.createRedisClusterConnectionFactory(this.host, this.port, this.password, this.connectTimeout, this.fixedTimeout);
    }

    public LettuceConnectionFactory createRedisClusterConnectionFactory(String host, int port, String password, Long connectTimeout, Long fixedTimeout) {
        RedisClusterNode node = new RedisClusterNode(host, port);
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.addClusterNode((RedisNode)node);
        config.setPassword(password);
        return new LettuceConnectionFactory(config, (LettuceClientConfiguration)this.configPool(connectTimeout, fixedTimeout));
    }

    private LettuceConnectionFactory createRedisConnectionFactory(int dbIndex, String host, int port, String password, Long connectTimeout, Long fixedTimeout) {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(dbIndex);
        redisStandaloneConfiguration.setHostName(host);
        redisStandaloneConfiguration.setPort(port);
        redisStandaloneConfiguration.setPassword(password);
        return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)this.configPool(connectTimeout, fixedTimeout));
    }

    private LettucePoolingClientConfiguration configPool(Long connectTimeout, Long fixedTimeout) {
        DefaultClientResources resources = DefaultClientResources.builder().reconnectDelay(Delay.fullJitter((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
        ClientOptions options = ClientOptions.builder().socketOptions(SocketOptions.builder().connectTimeout(Duration.ofMillis(connectTimeout)).build()).timeoutOptions(TimeoutOptions.builder().fixedTimeout(Duration.ofSeconds(fixedTimeout)).build()).build();
        return LettucePoolingClientConfiguration.builder().poolConfig(this.getPoolConfig()).clientResources((ClientResources)resources).clientOptions(options).build();
    }

    public GenericObjectPoolConfig getPoolConfig() {
        int redisPoolMaxIdle = ConfigTools3.getInt((String)"mfc.cloud.redis.pool.max-idle", (Integer)8);
        int redisPoolMinIdle = ConfigTools3.getInt((String)"mfc.cloud.redis.pool.min-idle", (Integer)0);
        int redisPoolMaxActive = ConfigTools3.getInt((String)"mfc.cloud.redis.pool.max-active", (Integer)8);
        int redisPoolMaxWait = ConfigTools3.getInt((String)"mfc.cloud.redis.pool.max-wait", (Integer)-1);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(redisPoolMaxIdle);
        poolConfig.setMinIdle(redisPoolMinIdle);
        poolConfig.setMaxTotal(redisPoolMaxActive);
        poolConfig.setMaxWaitMillis((long)redisPoolMaxWait);
        poolConfig.setTestOnBorrow(true);
        return poolConfig;
    }

    @Bean(name={"cloudRedisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(@Qualifier(value="cloudRedisConnectionFactory") RedisConnectionFactory cacheRedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(cacheRedisConnectionFactory);
        FastJsonRedisSerializer fastJsonRedisSerializer = new FastJsonRedisSerializer(Object.class);
        redisTemplate.setValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

