/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.mfcusercloud;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.cloud.cache.CloudRedisCache;
import com.valor.vod.cloud.mfcusercloud.GuavaCache;
import com.valor.vod.cloud.mfcusercloud.MfcUserCloudDao;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDdo;
import com.valor.vod.cloud.model.database.ddo.MfcCloudPkgDetailDdo;
import com.valor.vod.cloud.model.database.ddo.TenantAbstractLMI;
import com.valor.vod.cloud.model.database.dto.MfcCloudPkgDto;
import com.valor.vod.common.cache.redis.RedisCache;
import com.valor.vod.common.tools.cache.RedisTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudPkgCacheService {
    private static final Logger logger = LoggerFactory.getLogger(CloudPkgCacheService.class);
    @Autowired
    CloudRedisCache cloudRedisCache;
    @Autowired
    MfcUserCloudDao mfcUserCloudDao;
    GuavaCache pkgCache = null;
    boolean pkgCacheEnabled = true;

    @PostConstruct
    void init() {
        long pkgCacheSeconds = ConfigTools3.getLong((String)"mfc-cloud-pkg-cache-expiredSecends", (Long)300L);
        long pkgCacheSize = ConfigTools3.getLong((String)"mfc-cloud-pkg-cache-maxSize", (Long)20000L);
        this.pkgCache = new GuavaCache("pkg-cache", pkgCacheSeconds, pkgCacheSize);
        this.pkgCacheEnabled = ConfigTools3.getBoolean((String)"mfc-cloud-pkg-cache-enabled", (boolean)true);
    }

    public MfcCloudPkgDto getCloudPkgsByPkgId(Long pkgId) {
        Map<Long, MfcCloudPkgDto> pkgs = this.getCloudPkgsByPkgIds(SetTool.asHashSet((Object[])new Long[]{pkgId}));
        return pkgs.getOrDefault(pkgId, null);
    }

    public Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIds(Set<Long> pkgIds) {
        LinkedHashMap<Long, MfcCloudPkgDto> cachePkgs = new LinkedHashMap<Long, MfcCloudPkgDto>();
        if (this.pkgCacheEnabled) {
            for (Long pkgId : pkgIds) {
                MfcCloudPkgDto pkg = (MfcCloudPkgDto)this.pkgCache.get(String.valueOf(pkgId));
                if (pkg == null) continue;
                cachePkgs.put(pkgId, pkg);
            }
            if (cachePkgs.size() == pkgIds.size()) {
                return cachePkgs;
            }
        }
        long expiredTime = ConfigTools3.getLong((String)"mfc.cloud.pkg.expiredSeconds", (Long)14400L);
        Map map = RedisTools.gets((RedisCache)this.cloudRedisCache, (String)"cloud-pkgs-", pkgIds, (long)expiredTime, this::getCloudPkgsByPkgIdByDb);
        if (this.pkgCacheEnabled && !CollectionUtils.isNullOrEmpty((Map)map)) {
            for (Map.Entry e : map.entrySet()) {
                if (e.getValue() == null) continue;
                this.pkgCache.set(String.valueOf(e.getKey()), e.getValue());
            }
        }
        return map;
    }

    private Map<Long, MfcCloudPkgDto> getCloudPkgsByPkgIdByDb(Set<Long> pkgIds) {
        try {
            HashMap<Long, MfcCloudPkgDto> map = new HashMap<Long, MfcCloudPkgDto>();
            List<MfcCloudPkgDdo> pkgs = this.mfcUserCloudDao.getCloudPkgs(pkgIds);
            if (CollectionUtils.isNullOrEmpty(pkgs)) {
                return map;
            }
            List<MfcCloudPkgDetailDdo> details = this.mfcUserCloudDao.getCloudPkgDetails(pkgIds);
            if (CollectionUtils.isNullOrEmpty(details)) {
                return map;
            }
            Map<Long, List<MfcCloudPkgDetailDdo>> pkgDetailMap = details.stream().collect(Collectors.groupingBy(MfcCloudPkgDetailDdo::getPkgId));
            for (MfcCloudPkgDdo pkg : pkgs) {
                if (!pkgDetailMap.containsKey(pkg.getId())) continue;
                List<MfcCloudPkgDetailDdo> ds = pkgDetailMap.get(pkg.getId());
                MfcCloudPkgDto dto = new MfcCloudPkgDto();
                dto.setMfcCloudPkg(pkg);
                dto.setMfcCloudPkgDetails(ds);
                map.put(pkg.getId(), dto);
            }
            return map;
        }
        catch (Exception ex) {
            logger.error("getCloudPkgsByPkgIdByDb(),exception.", (Throwable)ex);
            throw ex;
        }
    }

    public void saveCloudPkg(MfcCloudPkgDdo pkg, List<MfcCloudPkgDetailDdo> details) {
        if (pkg == null || CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        ArrayList<TenantAbstractLMI> objects = new ArrayList<TenantAbstractLMI>();
        objects.add(pkg);
        objects.addAll(details);
        this.mfcUserCloudDao.storeAll(objects);
        this.cloudRedisCache.del(new String[]{"cloud-pkgs-" + pkg.getId()});
        if (this.pkgCacheEnabled) {
            this.pkgCache.del(String.valueOf(pkg.getId()));
        }
    }

    public void setCloudPkgDetails(List<MfcCloudPkgDetailDdo> details) {
        if (CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        Set<Long> pkgIds = details.stream().map(MfcCloudPkgDetailDdo::getPkgId).collect(Collectors.toSet());
        this.mfcUserCloudDao.storeAll(details);
        this.clearPkgCache(pkgIds);
    }

    public void delCloudPkgDetails(List<MfcCloudPkgDetailDdo> details) {
        if (CollectionUtils.isNullOrEmpty(details)) {
            return;
        }
        Set<Long> pkgIds = details.stream().map(MfcCloudPkgDetailDdo::getPkgId).collect(Collectors.toSet());
        this.mfcUserCloudDao.deleteAll(details);
        this.clearPkgCache(pkgIds);
    }

    public void clearPkgCache(Set<Long> pkgIds) {
        for (Long pkgId : pkgIds) {
            this.cloudRedisCache.del(new String[]{"cloud-pkgs-" + pkgId});
            if (!this.pkgCacheEnabled) continue;
            this.pkgCache.del(String.valueOf(pkgId));
        }
    }
}

