/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.blackGrey;

import com.valor.vod.cloud.model.database.dao.CloudBaseDao;
import com.valor.vod.cloud.model.database.ddo.CloudAcctBgDdo;
import common.base.tools.type.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="cloudTransactionManager")
public class CloudAcctBgDao
extends CloudBaseDao {
    @Autowired
    protected SessionFactory cloudSessionFactory;

    @Override
    @Transactional(value="cloudTransactionManager")
    public Session currentSession() {
        return this.cloudSessionFactory.getCurrentSession();
    }

    public long count(String account, Integer type) {
        Criteria criteria = this.currentSession().createCriteria(CloudAcctBgDdo.class);
        if (StringUtils.isNotBlank((String)account)) {
            criteria.add((Criterion)Restrictions.eq((String)"loginId", (Object)account.trim()));
        }
        if (type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)("%" + type)));
        }
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    @Transactional(value="cloudTransactionManager")
    public List<CloudAcctBgDdo> list(String account, Integer type, int start, int size) {
        Criteria criteria = this.currentSession().createCriteria(CloudAcctBgDdo.class);
        if (StringUtils.isNotBlank((String)account)) {
            criteria.add((Criterion)Restrictions.eq((String)"loginId", (Object)account.trim()));
        }
        if (type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        criteria.setFirstResult(start);
        criteria.setMaxResults(size);
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudAcctBgDdo>();
        }
        return results;
    }

    @Transactional(value="cloudTransactionManager")
    public List<CloudAcctBgDdo> queryList(List<Long> cids) {
        Criteria criteria = this.currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in((String)"cid", cids));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudAcctBgDdo>();
        }
        return results;
    }

    public List<Long> queryBlackList(List<Long> cids) {
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return new ArrayList<Long>();
        }
        Criteria criteria = this.currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in((String)"cid", cids));
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)0));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<Long>();
        }
        return results.stream().map(CloudAcctBgDdo::getCid).collect(Collectors.toList());
    }

    public List<CloudAcctBgDdo> queryValidList(List<Long> cids) {
        if (CollectionUtils.isNullOrEmpty(cids)) {
            return new ArrayList<CloudAcctBgDdo>();
        }
        Criteria criteria = this.currentSession().createCriteria(CloudAcctBgDdo.class);
        criteria.add(Restrictions.in((String)"cid", cids));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        List results = criteria.list();
        if (CollectionUtils.isNullOrEmpty((Collection)results)) {
            return new ArrayList<CloudAcctBgDdo>();
        }
        return results;
    }
}

