/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.util;

import com.google.gson.Gson;
import com.lark.oapi.Client;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.response.Body;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.valor.vod.cloud.model.util.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class LarkMsgUtil {
    private static final Logger logger = LoggerFactory.getLogger(LarkMsgUtil.class);
    private static Gson gson = new Gson();

    public static void sendLarkMsg(String msg, String secret, String api, String at) {
        RawResponse response = new RawResponse();
        try {
            long timeMillis = System.currentTimeMillis();
            int timestamp = (int)(timeMillis / 1000L);
            HashMap<String, Object> payload = new HashMap<String, Object>(16);
            HashMap<String, String> text = new HashMap<String, String>(16);
            StringBuilder sb = new StringBuilder(msg);
            if (StringUtils.isNotEmpty((CharSequence)at)) {
                String[] ats;
                for (String ait : ats = at.split(",")) {
                    sb.append("<at user_id=\"ou_xxx\">").append(ait).append("</at>");
                }
            }
            payload.put("msg_type", "text");
            text.put("text", sb.toString());
            payload.put("sign", LarkMsgUtil.genSign(secret, timestamp));
            payload.put("content", text);
            payload.put("timestamp", timestamp);
            Client client = Client.newBuilder((String)"appId", (String)"appSecret").openBaseUrl(BaseUrlEnum.LarkSuite).build();
            response = client.post(api, payload, AccessTokenType.None);
            if (response.getStatusCode() != HttpStatus.OK.value()) {
                logger.error("Lark send message error,statusCode:{},responseBody:{}", (Object)response.getStatusCode(), (Object)new String(response.getBody()));
                return;
            }
            Body body = (Body)UnmarshalRespUtil.unmarshalResp((RawResponse)response, Body.class);
            if (body == null || body.getCode() != 0) {
                logger.info("Lark send message error,responseStatusCode:{}, response:{}", (Object)response.getStatusCode(), (Object)body);
            }
        }
        catch (Exception e) {
            logger.error("Lark send text message error,message:{}, response:{}, errMsg:{}", new Object[]{msg, gson.toJson((Object)response), e.getMessage()});
        }
    }

    private static String genSign(String secret, int timestamp) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(stringToSign.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] signData = mac.doFinal(new byte[0]);
        return new String(Base64Utils.encode(signData));
    }
}

