/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.cloud.model.util.stat;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.stat.MetricTools;
import common.base.tools.type.CollectionUtils;
import common.base.tools.type.DateTimeTools;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class CountStatisticsTools {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Map<String, Map<String, Long>> countMap4LT = Maps.newConcurrentMap();
    public static final Map<String, Map<String, Long>> countMap4Tmp = Maps.newConcurrentMap();
    public static long startupTime = System.currentTimeMillis();
    public static long cycleStartTime = System.currentTimeMillis();
    private static final String STAT_ITEM_REQ = "REQ";
    private static final String STAT_ITEM_RSP = "RSP";
    private static final String STAT_ITEM_ERROR = "ERROR";
    private static boolean report2Remote = false;

    public static void report2Remote(boolean report) {
        report2Remote = report;
    }

    public static void addReq(String key) {
        CountStatisticsTools.addReq(key, 1);
    }

    public static void addRsp(String key) {
        CountStatisticsTools.addRsp(key, 1);
    }

    public static void addError(String key) {
        CountStatisticsTools.addError(key, 1);
    }

    public static void addReq(String key, int count) {
        CountStatisticsTools.addCount(countMap4Tmp, key, STAT_ITEM_REQ, count);
    }

    public static void addRsp(String key, int count) {
        CountStatisticsTools.addCount(countMap4Tmp, key, STAT_ITEM_RSP, count);
    }

    public static void addError(String key, int count) {
        CountStatisticsTools.addCount(countMap4Tmp, key, STAT_ITEM_ERROR, count);
    }

    public static void report2Metric(Map<String, Map<String, Long>> countMap4Tmp) {
        if (!CollectionUtils.isNullOrEmpty(countMap4Tmp)) {
            countMap4Tmp.forEach((k, v) -> MetricTools.logCount((String)k.replace("-", "_"), (Map)v));
        }
    }

    public static String dumpMutilLine(boolean merge) {
        if (merge) {
            CountStatisticsTools.merge2LT(countMap4Tmp, countMap4LT);
        }
        long timeNow = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        if (merge) {
            sb.append(CountStatisticsTools.dumpCount(countMap4LT, startupTime, timeNow, true));
        }
        sb.append(CountStatisticsTools.dumpCount(countMap4Tmp, cycleStartTime, timeNow, false));
        cycleStartTime = timeNow;
        if (report2Remote) {
            CountStatisticsTools.report2Metric(countMap4Tmp);
        }
        countMap4Tmp.clear();
        return sb.toString();
    }

    public static String dumpCount(Map<String, Map<String, Long>> countMap, long startTime, long endTime, boolean lt) {
        if (CollectionUtils.isNullOrEmpty(countMap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR);
        if (lt) {
            sb.append("Count(From Start):[");
        } else {
            sb.append("Count:[");
        }
        sb.append(DateTimeTools.millis2DateStr((long)startTime)).append(" --- ").append(DateTimeTools.millis2DateStr((long)endTime)).append("]");
        TreeMap sortCountMap = Maps.newTreeMap((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortCountMap.putAll(countMap);
        sb.append(LINE_SEPARATOR);
        if (!CollectionUtils.isNullOrEmpty((Map)sortCountMap)) {
            sortCountMap.forEach((k, v) -> {
                if (!CollectionUtils.isNullOrEmpty((Map)v)) {
                    sb.append("\t");
                    sb.append(Strings.padEnd((String)k, (int)30, (char)' '));
                    sb.append(Strings.padEnd((String)STAT_ITEM_REQ, (int)3, (char)' '));
                    sb.append(":");
                    sb.append(Strings.padEnd((String)String.valueOf(v.getOrDefault(STAT_ITEM_REQ, 0L)), (int)10, (char)' '));
                    sb.append(Strings.padEnd((String)STAT_ITEM_RSP, (int)3, (char)' '));
                    sb.append(":");
                    sb.append(Strings.padEnd((String)String.valueOf(v.getOrDefault(STAT_ITEM_RSP, 0L)), (int)10, (char)' '));
                    sb.append(Strings.padEnd((String)STAT_ITEM_ERROR, (int)3, (char)' '));
                    sb.append(":");
                    sb.append(Strings.padEnd((String)String.valueOf(v.getOrDefault(STAT_ITEM_ERROR, 0L)), (int)10, (char)' '));
                    sb.append(LINE_SEPARATOR);
                }
            });
        }
        return sb.toString();
    }

    private static void merge2LT(Map<String, Map<String, Long>> countMap4Tmp, Map<String, Map<String, Long>> countMap4LT) {
        if (CollectionUtils.isNullOrEmpty(countMap4Tmp)) {
            return;
        }
        countMap4Tmp.forEach((k, v) -> {
            Map v1 = (Map)countMap4LT.get(k);
            if (CollectionUtils.isNullOrEmpty((Map)v1)) {
                countMap4LT.put((String)k, (Map<String, Long>)v);
            } else {
                v.forEach((k2, v2) -> {
                    Long v3 = (Long)v1.get(k2);
                    if (v3 == null) {
                        v1.put(k2, v2);
                    } else {
                        v1.put(k2, v2 + v3);
                    }
                });
            }
        });
    }

    private static void addCount(Map<String, Map<String, Long>> statMap, String key, String item, long count) {
        HashMap statCount = statMap.get(key);
        if (CollectionUtils.isNullOrEmpty(statCount)) {
            statCount = Maps.newHashMap();
            statCount.put(item, count);
            statMap.put(key, statCount);
        } else {
            Long v = (Long)statCount.get(item);
            if (v == null) {
                statCount.put(item, count);
            } else {
                statCount.replace(item, v + count);
            }
        }
    }
}

