package com.valor.vod.common.web.aop.processor;


import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.response.IResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;


/**
 * File        :
 * Description :
 * Author      : Frank
 * Created     : 2016/1/1 22:13
 */
public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);

    public static void logReq(HttpServletRequest request, IRequestArgs args) {
        logger.info("[REQ] [HOST]:[{}] [QUERY STRING]:[{}?{}] ARGS[{}]",
            HttpTools.getRemoteHost(request),
            getRequestURL(request),
            getQueryString(request),
            args == null ? "-" : args.toString());
    }

    public static void logRsp(String host,
                              String apiName,
                              IResponse response,
                              IRequestArgs args) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]",
            apiName, response, args == null ? "" : args.toString());
    }


    public static void logRsp(String host,
                              String apiName,
                              IRequestArgs args,
                              ResponseStatus response) {
        logger.info("[RSP] [API]:[{}] [{}]  ", apiName, response);
    }


    private static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    private static String getRequestURL(HttpServletRequest request) {
        return request.getRequestURI();
    }
}
