package com.valor.vod.common.web.crypt.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.valor.vod.common.web.crypt.CryptMsgTools;
import common.base.tools.JSON.GsonTypeAdapter;
import common.base.tools.type.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class RequestCryptFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);

    private Gson gson = new GsonBuilder().
        registerTypeAdapter(new TypeToken<Map<String, Object>>() {
        }.getType(), new GsonTypeAdapter())
        .create();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {
        RequestCryptWrapper wrapper = new RequestCryptWrapper(request);
        String v = wrapper.getParameter("v");
        String m = wrapper.getParameter("m");
        String s = wrapper.getParameter("s");
        //logger.info("API:[{}] REQ[v:[{}] s:[{}] m:[{}]", HttpTools.getApiPath(request),v,s,m);
        if (!Strings.isNullOrEmpty(v) && !Strings.isNullOrEmpty(m)) {
            try {
                String dm = CryptMsgTools.decryptArg(v, m, s);
                Map<String, Object> decryptMap = gson.fromJson(dm, new TypeToken<Map<String, Object>>() {
                }.getType());

                if (!CollectionUtils.isNullOrEmpty(decryptMap)) {
                    wrapper.addAllParameters(decryptMap);
                }
                wrapper.setOriginalBodyStr(dm);
            } catch (Exception e) {
                logger.error("Exception:{}", e);
                throw new IllegalArgumentException(e.toString());
            }
        } else {
            wrapper.updateOriginalBodyStrFromBodyStr();
        }

        filterChain.doFilter(wrapper, response);
    }

    @Override
    public void destroy() {
        // empty interface implementation
    }

}
