package com.valor.vod.common.web.crypt.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.crypt.CryptACL;
import com.valor.vod.common.web.crypt.CryptMsgTools;
import com.valor.vod.common.web.crypt.model.ApiCryptMsg;
import common.base.tools.sys.SystemTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;

public class ResponseCryptFilter extends OncePerRequestFilter {

    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);

    private Gson gson = new Gson();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {
        RequestCryptWrapper reqWrapper = new RequestCryptWrapper(request);
        String v = reqWrapper.getParameter("v");
        String url = HttpTools.getRequestURI(request);

        if (Strings.isNullOrEmpty(v) || CryptACL.isResponseOri(url)) {
            filterChain.doFilter(request, response);
        } else {
            try (OutputStream out = response.getOutputStream()) {
                ResponseCryptWrapper wrapper = new ResponseCryptWrapper(response);
                filterChain.doFilter(request, wrapper);

                if (CryptACL.isContentTypeCrype(wrapper.getContentType()))
                    out.write(wrapper.getData());
                else {
                    String cryptMsg = getCryptMessage(url, v, wrapper.getData());
                    out.write(cryptMsg.getBytes("utf-8"));
                }
            } finally {
            }
        }
    }

    @Override
    public void destroy() {
        // empty interface implementation
    }

    private String getCryptMessage(String url, String prot, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        try {
            ApiCryptMsg msg = new ApiCryptMsg();
            msg.setH(SystemTools.getHostnameMD5());
            msg.setT(System.currentTimeMillis());

            if (cryptEnable
                && (prot.equalsIgnoreCase(ApiCryptMsg.PROT_3) || prot.equalsIgnoreCase(ApiCryptMsg.PROT_4) || prot.equalsIgnoreCase(ApiCryptMsg.PROT_5))) {
                msg.setV(prot);
                msg.setM(CryptMsgTools.encryptMsg(prot, data));
            } else {
                msg.setV("0");
                msg.setM(new String(data, "UTF-8"));
            }
            msg.setS(CryptMsgTools.getSign(prot, msg.getM()));
            //logger.info("API:[{}] RSP:[{}]", url, msg.toString());
            return gson.toJson(msg);

        } finally {

        }
    }
}
