package com.valor.vod.common.web.filter.sso;

import com.valor.vod.api.common.encrypt.RSABase64Utils;
import com.valor.vod.api.model.user.EAccountType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2016/7/11.
 */
public class SSOTools {
    private static final Logger logger = LoggerFactory.getLogger(SSOTools.class);

    public static String encodeToken(TokenV2 token, String ASPrivateKey) {
        if (token == null) {
            return "";
        }

        try {
            return RSABase64Utils.encriptByPrivateKey(token.toSerializeString().getBytes(), ASPrivateKey);
        } catch (Exception e) {
            logger.error("{}", e);
            return "";
        }
    }

    public static TokenV2 decodeToken(String tokenStr, String ASKey) {
        try {
            byte[] bytesToken = RSABase64Utils.decryptByPublicKey(tokenStr, ASKey);
            return TokenV2.valueOf(new String(bytesToken));
        } catch (Exception e) {
            logger.error("{}", e);
            return null;
        }
    }

    public static String sign(String data, String ASPrivateKey) {
        try {
            //StatTools.startMethodTimer("SSOTools.sign");
            return RSABase64Utils.sign(data, ASPrivateKey);
        } catch (Exception e) {
            logger.error("{}", e);
            return "";
        } finally {
            //StatTools.stopMethodTimer("SSOTools.sign");
        }
    }

    public static String encodeTokenV1(TokenV1 token, String ASPrivateKey) {
        if (token == null) {
            return "";
        }

        try {
            return RSABase64Utils.encriptByPrivateKey(token.toSerializeString().getBytes(), ASPrivateKey);
        } catch (Exception e) {
            logger.error("{}", e);
            return "";
        }
    }

    public static TokenV1 decodeTokenV1(String tokenStr, String ASKey) {
        try {
            byte[] bytesToken = RSABase64Utils.decryptByPublicKey(tokenStr, ASKey);
            return TokenV1.valueOf(new String(bytesToken));
        } catch (Exception e) {
            logger.error("{}", e);
            return null;
        }
    }

    public static void main(String[] args) {
        TokenV2 token = new TokenV2();
        token.setAccountId(173L);
        token.setDid("");
        token.setDid2(-1L);
        token.setUserProps(1L);
        token.setGenerateTimestamp(System.currentTimeMillis());
        token.setClientType(TokenV2.TOKEN_FOR_WEB);
        token.setExpireTimestamp(token.getGenerateTimestamp() + 24 * 60 * 60L * 1000);
        token.put(AuthTokenFiled.ACCOUNT_TYPE.name(), EAccountType.ACCOUNT.getCode());
        token.put(AuthTokenFiled.CLIENT_SESSION.name(), "");
        String ASPrivateKey = "MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAwGCwSnyaNqkT2dN866ZrJ0n5xzO7F5BJehXER6v2k3Ad9eDsCJBXZlZreizZXRjBYzt-naoL-9kHbg-0LSzilwIDAQABAkEAjyplh8la6rrBLyYYnTZoIAEJhZmV7l9OjzCLtdrf0bAdDU6zLg_StZeKSdw8byaeSd5MNMSXB-3Fx57lGGU7QQIhAP3pQ-fElTPrhrAPk3gPm5wKBCMNjzpSyf6jGkW5FA7ZAiEAwfXVmO6Ir-7n1fKTIeDHQMQqPtiDvD36B5wXxs6Tdu8CIE71ZyR_wVYv--ZsMZO4Zs-TXc34vX2JmT8SQW1FLLOhAiAOnH9XwvhnEH9Efb6Zub4o4d4w18ysvJp-QkMERgGT3wIhAKgyzmKSA8VDDrSWZ74jEJKkhLklegc6obkn26zkHgT0";
        String s = SSOTools.encodeToken(token, ASPrivateKey);
        System.out.println(s);
//        System.out.println(decodeTokenV1(s,));
    }
}
