package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;

public class Token implements Serializable {
  private static final long serialVersionUID = 4237421562376740942L;

  private static final int CURRENT_VERSION = 20170909;

  private int version = CURRENT_VERSION;
  private String email = "";
  private long startTime = System.currentTimeMillis();
  private String ip = "";

  public Token() {
    super();
  }

  public Token(String email, String ip) {
    super();
    this.email = email;
    this.ip = ip;
  }

  public static Token valueOf(String str) {
    if (Strings.isNullOrEmpty(str)) {
      return null;
    }

    List<String> valueList = Splitter.on("#!").splitToList(str);
    if (valueList.isEmpty()) {
      return null;
    }

    Token serviceToken = new Token();

    serviceToken.setVersion(Integer.valueOf(valueList.get(0)));
    serviceToken.setEmail(valueList.get(1));
    serviceToken.setStartTime(Long.valueOf((valueList.get(2))));
    serviceToken.setIp(valueList.get(3));

    if (serviceToken.getVersion() != CURRENT_VERSION) return null;

    return serviceToken;
  }

  public int getVersion() {
    return version;
  }

  public void setVersion(int version) {
    this.version = version;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public long getStartTime() {
    return startTime;
  }

  public void setStartTime(long startTime) {
    this.startTime = startTime;
  }

  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public String toSerializeString() {
    return Joiner.on("#!").join(version, email, startTime, ip);
  }
}
