/*
 * Created by Gabriel Souza on 11/09/18 17:29
 * Copyright Valoroso Ltd. (c) 2018.  All rights reserved.
 */

package com.valor.vod.common.web.util;

import common.config.tools.config.ConfigTools3;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Response;

import java.util.concurrent.TimeUnit;

public class HttpConnectionFactory {

    private HttpConnectionFactory() {
        throw new IllegalStateException("Utility class");
    }

    private static int getHttpClientTimeout() {
        return ConfigTools3.getInt("httpclient.timeout", 60000);
    }

    private static int getHttpClientRetries() {
        return ConfigTools3.getInt("httpclient.retries", 2);
    }

    public static OkHttpClient getClient() {
        return new OkHttpClient.Builder().readTimeout(getHttpClientTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true)
            .connectTimeout(getHttpClientTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public static OkHttpClient getAuthenticatedClient(final String username,
                                                      final String password) {
        // build client with authentication information.
        return new OkHttpClient.Builder().readTimeout(getHttpClientTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true)
            .connectTimeout(getHttpClientTimeout(), TimeUnit.MILLISECONDS).authenticator((route, response) -> {
                String credential = Credentials.basic(username, password);
                if (responseCount(response) > getHttpClientRetries()) {
                    return null;
                }
                return response.request().newBuilder().header("Authorization", credential).build();
            }).build();
    }

    private static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            result++;
        }
        return result;
    }
}