/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.web.aop.annotation.WebApiCallLiteV1;
import com.valor.vod.common.web.request.BaseRequestArgs;
import com.valor.vod.common.web.request.IRequestBaseArgs;
import common.base.tools.exception.ApiException;
import common.base.tools.statistics.CountStatisticsTools2;
import common.config.tools.config.ConfigTools3;
import common.web.tools.http.model.response.WebApiBaseResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Aspect
@Order(value=1)
public class WebApiCallInterceptorLiteV1 {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCallInterceptorLiteV1.class);

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.WebApiCallLiteV1)")
    public void webApiCall() {
    }

    @Around(value="com.valor.vod.common.web.aop.processor.WebApiCallInterceptorLiteV1.webApiCall()&&@annotation(wac)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiCallLiteV1 wac) throws ServletException, IOException, ApiException {
        String apiName = this.getApiName((JoinPoint)pjp);
        CountStatisticsTools2.addCount((String)apiName, (String)"REQ", (long)1L);
        HttpServletRequest request = this.getRequest((JoinPoint)pjp);
        HttpServletResponse response = this.getResponse((JoinPoint)pjp);
        BaseRequestArgs baseArgs = this.getArgs((JoinPoint)pjp);
        if (baseArgs != null) {
            baseArgs.setArgsFromParameter(request);
        }
        try {
            Object retVal = pjp.proceed();
            boolean isSuccess = this.isSuccess(retVal);
            if (isSuccess) {
                CountStatisticsTools2.addCount((String)apiName, (String)"RSP", (long)1L);
                if (this.getCacheControl(wac, apiName) > 0) {
                    this.getResponse((JoinPoint)pjp).setHeader("Cache-Control", "max-age=" + wac.cacheControl());
                }
            } else {
                response.setStatus(555);
                CountStatisticsTools2.addCount((String)apiName, (String)"ERR", (long)1L);
            }
            return retVal;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ApiException) {
                throw (ApiException)throwable;
            }
            logger.error(String.format("API:[%s]", apiName), throwable);
            throw new ApiException(1, 101, "Internal error");
        }
    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof HttpServletRequest)) continue;
            return (HttpServletRequest)arg;
        }
        return null;
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof HttpServletResponse)) continue;
            return (HttpServletResponse)arg;
        }
        return null;
    }

    public BaseRequestArgs getArgs(JoinPoint jp) {
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof BaseRequestArgs)) continue;
            return (BaseRequestArgs)arg;
        }
        return null;
    }

    public String getApiName(JoinPoint jp) {
        String apiName = this.getRequest(jp).getRequestURI();
        apiName = apiName.substring(1).replace("/", "-");
        return apiName;
    }

    public String getApiPath(JoinPoint jp) {
        return this.getRequest(jp).getRequestURI();
    }

    private void logRequest(WebApiCallLiteV1 webApiCall, String host, String apiName, IRequestBaseArgs args) {
        if (this.getLogLevel(webApiCall, apiName, "request") == 0) {
            return;
        }
        this.logReq(host, apiName, this.obj2String(args));
    }

    private void logResponse(WebApiCallLiteV1 webApiCall, String host, String apiName, Object result, IRequestBaseArgs iArgs) {
        if (this.getLogLevel(webApiCall, apiName, "response") == 0) {
            return;
        }
        this.logResponse(true, host, apiName, result, iArgs);
    }

    private void logResponse(boolean isSuccess, String host, String apiName, Object result, IRequestBaseArgs iArgs) {
        if (isSuccess) {
            this.logRsp(host, apiName, this.obj2String(iArgs), this.obj2String(result));
        } else {
            this.logErrRsp(host, apiName, this.obj2String(iArgs), this.obj2String(result));
        }
    }

    private boolean isSuccess(Object result) {
        if (result instanceof ResponseStatus) {
            return ((ResponseStatus)result).getRetCode() == 0;
        }
        if (result instanceof WebApiBaseResponse) {
            return ((WebApiBaseResponse)result).getRetCode() == 0;
        }
        return false;
    }

    private int getMinVersion(WebApiCallLiteV1 webApiCall, String apiName) {
        String minVerKey = "webapi.version.min";
        String apiVerKey = String.format("%s.%s", "webapi.version.min", apiName);
        int minVersion = ConfigTools3.getInt((String)apiVerKey, (Integer)ConfigTools3.getInt((String)"webapi.version.min", (Integer)0));
        if (minVersion == 0) {
            minVersion = webApiCall.minVersion();
        }
        return minVersion;
    }

    private int getLogLevel(WebApiCallLiteV1 webApiCall, String apiName, String msgType) {
        String defaultKey = "webapi.log.level";
        String apiMsgKey = String.format("%s.%s.%s", "webapi.log.level", msgType, apiName);
        String apiKey = String.format("%s.%s", "webapi.log.level", apiName);
        int value = ConfigTools3.getInt((String)apiMsgKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)apiKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)"webapi.log.level", (Integer)0);
        if (value != 0) {
            return value;
        }
        value = webApiCall.logLevel();
        return value;
    }

    private int getCacheControl(WebApiCallLiteV1 webApiCall, String apiName) {
        String defaultKey = "webapi.cache.control";
        String apiKey = String.format("%s.%s", "webapi.cache.control", apiName);
        int value = ConfigTools3.getInt((String)apiKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)"webapi.cache.control", (Integer)0);
        if (value != 0) {
            return value;
        }
        return webApiCall.cacheControl();
    }

    private String obj2String(Object obj) {
        if (obj == null) {
            return "-";
        }
        return obj.toString();
    }

    private void logReq(String host, String apiName, String request) {
        logger.info("[REQ] [HOST]:[{}] [API]:[{}]req[{}]", new Object[]{host, apiName, request});
    }

    private void logRsp(String host, String apiName, String request, String response) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, request});
    }

    private void logErrRsp(String host, String apiName, String request, String response) {
        logger.error("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, request});
    }
}

