/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.google.common.base.Strings;
import com.valor.vod.common.model.token.ServiceToken;
import com.valor.vod.common.tools.http.HttpParameterTools;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.tools.sso.ServiceTokenTools;
import com.valor.vod.common.web.aop.annotation.WebApiCheckServiceToken;
import common.base.tools.exception.ApiException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Aspect
@Service
public class WebApiCheckServiceTokenInterceptorV1 {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCheckServiceTokenInterceptorV1.class);

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.WebApiCheckServiceToken)")
    public void webApiCheckServiceToken() {
    }

    @Before(value="com.valor.vod.common.web.aop.processor.WebApiCheckServiceTokenInterceptorV1.webApiCheckServiceToken()&&@annotation(wapiCST)")
    public void webApiCheckServiceTokenProcessor(JoinPoint jp, WebApiCheckServiceToken wapiCST) throws ApiException {
        HttpServletRequest request = (HttpServletRequest)jp.getArgs()[0];
        Long appVer = HttpTools.getLongParameter((HttpServletRequest)request, (String)"appVer");
        if (appVer == null) {
            throw new ApiException(6, 601, "App version is empty.");
        }
        if (appVer <= (long)wapiCST.minSupportAppVer()) {
            logger.info("Version not support Service token.");
            return;
        }
        String st = HttpParameterTools.getParameter((HttpServletRequest)request, (String)"st");
        if (Strings.isNullOrEmpty((String)st)) {
            logger.warn("Service token is empty");
            throw new ApiException(9, 903, "Service token is empty");
        }
        ServiceToken serviceToken = ServiceTokenTools.decodeServiceToken((String)st);
        if (serviceToken == null) {
            logger.error("Invalid Service Token(decode error):{}", (Object)st);
            throw new ApiException(9, 902, "Invalid service token(decode error)");
        }
        String did = HttpParameterTools.getParameter((HttpServletRequest)request, (String)"did");
        if (!did.equalsIgnoreCase(serviceToken.getDid())) {
            logger.error("Invalid Service Token did[{}-{}]", (Object)did, (Object)serviceToken.getDid());
            throw new ApiException(9, 902, "Invalid service token(Forged)");
        }
    }
}

