/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;

public class CryptACL {
    private static String CRYPT_CONFIG_KEY = "mfc.api.crypt";
    private static String CRYPT_RESPONSE_ORI_KEY = "mfc.api.crypt.response.ori";
    private static String CRYPT_RESPONSE_CONTENT_TYPE_KEY = "mfc.api.crypt.response.contentType";
    private static String CRYPT_CONFIG_KEY_TIME_LOG = "mfc.api.crypt.debug.time";

    public static boolean isContentTypeCrype(String contentType) {
        return ConfigTools3.getAsList((String)CRYPT_RESPONSE_CONTENT_TYPE_KEY).contains(contentType);
    }

    public static boolean isCryptEnable(String api) {
        return ConfigTools3.getBoolean((String)CryptACL.getCryptKey(api), (boolean)ConfigTools3.getBoolean((String)CRYPT_CONFIG_KEY, (boolean)false));
    }

    public static boolean isDebugTime() {
        return ConfigTools3.getBoolean((String)CRYPT_CONFIG_KEY_TIME_LOG, (boolean)false);
    }

    private static String getCryptKey(String api) {
        return String.format("%s.%s", CRYPT_CONFIG_KEY, Strings.nullToEmpty((String)api));
    }

    public static boolean isResponseOri(String api) {
        return ConfigTools3.getBoolean((String)CryptACL.getCryptResKey(api), (!ConfigTools3.getBoolean((String)CRYPT_CONFIG_KEY, (boolean)false) ? 1 : 0) != 0);
    }

    private static String getCryptResKey(String api) {
        return String.format("%s.%s", CRYPT_RESPONSE_ORI_KEY, Strings.nullToEmpty((String)api));
    }
}

