/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.valor.vod.common.web.crypt.CryptMsgTools;
import com.valor.vod.common.web.crypt.filter.RequestCryptWrapper;
import common.base.tools.JSON.GsonTypeAdapter;
import common.base.tools.type.CollectionUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new GsonTypeAdapter()).create();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestCryptWrapper wrapper = new RequestCryptWrapper(request);
        String v = wrapper.getParameter("v");
        String m = wrapper.getParameter("m");
        String s = wrapper.getParameter("s");
        if (!Strings.isNullOrEmpty((String)v) && !Strings.isNullOrEmpty((String)m)) {
            try {
                String dm = CryptMsgTools.decryptArg(v, m, s);
                Map decryptMap = (Map)this.gson.fromJson(dm, new TypeToken<Map<String, Object>>(){}.getType());
                if (!CollectionUtils.isNullOrEmpty((Map)decryptMap)) {
                    wrapper.addAllParameters(decryptMap);
                }
                wrapper.setOriginalBodyStr(dm);
            }
            catch (Exception e) {
                logger.error("Exception:{}", (Throwable)e);
                throw new IllegalArgumentException(e.toString());
            }
        } else {
            wrapper.updateOriginalBodyStrFromBodyStr();
        }
        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
    }

    public void destroy() {
    }
}

