/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt.filter;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.valor.vod.common.web.crypt.filter.ServletInputStreamWrapper;
import common.base.tools.JSON.GsonTypeAdapter;
import common.base.tools.type.CollectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCryptWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptWrapper.class);
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private String bodyStr = "";
    private String originalBodyStr = "";
    private Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new GsonTypeAdapter()).create();

    public RequestCryptWrapper(HttpServletRequest request) {
        super(request);
        if (!Strings.isNullOrEmpty((String)request.getContentType()) && request.getContentType().toLowerCase().contains("multipart/form-data")) {
            logger.info("ContentType is multipart/form-data,request:[{}]", (Object)request.getRequestURI());
        } else {
            this.bodyStr = this.getRequestBody(request);
        }
        this.parameterMap.putAll(request.getParameterMap());
    }

    private String getRequestBody(HttpServletRequest request) {
        Map postMap;
        boolean isForm;
        boolean isOriginalRequest = !(request instanceof RequestCryptWrapper);
        boolean bl = isForm = request.getContentType() != null && (request.getContentType().startsWith(ContentType.APPLICATION_FORM_URLENCODED.getMimeType()) || request.getContentType().startsWith(ContentType.MULTIPART_FORM_DATA.getMimeType()));
        if (isOriginalRequest && isForm) {
            return "";
        }
        String requestBody = this.getRequestBodyString(request);
        if (!Strings.isNullOrEmpty((String)requestBody) && !CollectionUtils.isNullOrEmpty((Map)(postMap = (Map)this.gson.fromJson(requestBody, Map.class)))) {
            postMap.forEach((k, v) -> this.addParameter((String)k, v));
        }
        return Strings.nullToEmpty((String)requestBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestBodyString(HttpServletRequest request) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            br = request.getReader();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamWrapper(Strings.nullToEmpty((String)this.originalBodyStr).getBytes(Charsets.UTF_8));
    }

    public String getHeader(String name) {
        String originalHeader = super.getHeader(name);
        if (name.equalsIgnoreCase("content-type") && !Strings.isNullOrEmpty((String)this.originalBodyStr) && !Strings.isNullOrEmpty((String)originalHeader)) {
            return originalHeader.replace("application/x-www-form-urlencoded", "application/json");
        }
        return originalHeader;
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList headList;
        Enumeration headers = super.getHeaders(name);
        if (name.equalsIgnoreCase("Content-Type") && !Strings.isNullOrEmpty((String)this.originalBodyStr) && headers.hasMoreElements() && !CollectionUtils.isNullOrEmpty(headList = Collections.list(headers)) && headList.contains("application/x-www-form-urlencoded")) {
            Collections.replaceAll(headList, "application/x-www-form-urlencoded", "application/json");
            return Collections.enumeration(headList);
        }
        return headers;
    }

    public String getContentType() {
        String originalContentType = this.getHeader("content-type");
        if (!Strings.isNullOrEmpty((String)this.originalBodyStr) && !Strings.isNullOrEmpty((String)originalContentType)) {
            return originalContentType.replace("application/x-www-form-urlencoded", "application/json");
        }
        return originalContentType;
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        if (!CollectionUtils.isNullOrEmpty(otherParams)) {
            for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setOriginalBodyStr(String originalBodyStr) {
        this.originalBodyStr = originalBodyStr;
    }

    public void updateOriginalBodyStrFromBodyStr() {
        if (!Strings.isNullOrEmpty((String)this.bodyStr)) {
            this.originalBodyStr = this.bodyStr;
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.parameterMap.put(name, (String[])value);
            } else if (value instanceof String) {
                this.parameterMap.put(name, new String[]{(String)value});
            } else {
                this.parameterMap.put(name, new String[]{String.valueOf(value)});
            }
        }
    }
}

