/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.RSABase64Utils;
import com.valor.vod.common.tools.http.ASKeyConfig;
import com.valor.vod.common.tools.http.HttpParameterTools;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.filter.sso.AbstractSSOFilter;
import com.valor.vod.common.web.filter.sso.AuthTokenFiled;
import com.valor.vod.common.web.filter.sso.HeaderMapRequestWrapper;
import com.valor.vod.common.web.filter.sso.TokenV2;
import common.config.tools.config.ConfigTools3;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOTokenFilter
extends AbstractSSOFilter {
    private static final Logger logger = LoggerFactory.getLogger(SSOTokenFilter.class);

    public SSOTokenFilter() {
        this.excludedSet.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)this.getStringTokenFilterExclude()));
    }

    @Override
    public String getToken(HttpServletRequest httpRequest) {
        return HttpParameterTools.getParameter((HttpServletRequest)httpRequest, (String)"token");
    }

    @Override
    public byte[] decryptToken(String token) {
        try {
            return RSABase64Utils.decryptByPublicKey((String)token, (String)ASKeyConfig.getAsKey());
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return new byte[0];
        }
    }

    @Override
    public int verifyToken(HeaderMapRequestWrapper httpRequest, Object object) {
        String host = HttpTools.getRemoteHost((HttpServletRequest)httpRequest);
        if (object instanceof TokenV2) {
            String did;
            TokenV2 token = (TokenV2)object;
            long curMS = System.currentTimeMillis();
            if (curMS >= token.getExpireTimestamp()) {
                logger.error("==========HOST:[{}] MAC:[{}] Token expire[{}-{}-{}]", new Object[]{host, token.getDid(), curMS, token.getExpireTimestamp(), token.getExpireTimestamp()});
                return 203;
            }
            Long uid = HttpParameterTools.getLongParameter((HttpServletRequest)httpRequest, (String)"uid");
            if (uid != null && uid > 0L && uid.longValue() != token.getDid2()) {
                logger.error("==========HOST:[{}] QueryString[{}]", (Object)host, (Object)httpRequest.getQueryString());
                logger.error("==========HOST:[{}] uid:[{}] INVALID UID[{}]", new Object[]{host, uid, token.getDid2()});
                return 205;
            }
            Long accountId = HttpParameterTools.getLongParameter((HttpServletRequest)httpRequest, (String)"accountId");
            if (accountId != null && accountId > 0L && accountId.longValue() != token.getAccountId().longValue()) {
                logger.error("==========HOST:[{}] QueryString[{}]", (Object)host, (Object)httpRequest.getQueryString());
                logger.error("==========HOST:[{}] uid:[{}] INVALID ACCOUNT ID[{}]", new Object[]{host, uid, token.getAccountId()});
                return 223;
            }
            if (token.getClientType() == 2 && (Strings.isNullOrEmpty((String)(did = HttpParameterTools.getParameter((HttpServletRequest)httpRequest, (String)"did"))) || !did.equalsIgnoreCase(token.getDid()))) {
                logger.error("==========HOST:[{}] MAC:[{}] Invalid Mac[{}]", new Object[]{host, did, token.getDid()});
                return 202;
            }
            httpRequest.setAttribute("_accountId", token.getAccountId());
            httpRequest.setAttribute("_did", token.getDid());
            httpRequest.setAttribute("_uid", token.getDid2());
            httpRequest.setAttribute("_ts", token.getGenerateTimestamp());
            httpRequest.setAttribute("_uprop", token.getUserProps());
            httpRequest.setAttribute("_token", this.getToken((HttpServletRequest)httpRequest));
            httpRequest.setAttribute("accountType", token.get(AuthTokenFiled.ACCOUNT_TYPE.name()));
            try {
                httpRequest.setAttribute("_rootNodeId", token.getRootNodeId());
                httpRequest.setAttribute("_productId", token.getProductId());
            }
            catch (Exception e2) {
                httpRequest.setAttribute("_rootNodeId", 0L);
                httpRequest.setAttribute("_productId", 0L);
            }
            if (token.getVersion() >= 20180808) {
                httpRequest.setAttribute("clientSession", token.get(AuthTokenFiled.CLIENT_SESSION.name()));
            }
            return 0;
        }
        logger.error("==========HOST:[{}] Invalid token", (Object)host);
        return 201;
    }

    @Override
    public Object getTokenObj(HttpServletRequest httpRequest, byte[] bytes) {
        return TokenV2.valueOf(bytes);
    }

    private String getStringTokenFilterExclude() {
        String defaultTokenFilterExclude = "/api/uc/quicklogin/v1, /api/user/unLockScreen/v1, /api/user/resetScreenPwd/v1, /api/user/restoreScreenPwd/v1, /api/oauth/tokenLogin/v1, /api/user/register/v3, /api/user/register/v2, /api/user/area/list/v1, /api/user/verificationCode/send/v1, /api/user/mobile/register/v1, /api/uc/register/v2, /api/uc/login/v2, /api/user/charge/rechargeByAgent/v1, /api/user/charge/rechargeByAgent/rollback/v1, /api/notification/list/v1, /api/notification/list/banner, /api/notification/getLatestUpdateTime/v1, /api/user/bindEmail/activate/v1, /api/user/register/v1, /api/user/getEmail/v1, /api/notification/getTips/v1, /api/ping/*, /api/version/*, /api/error/v1, /api/production/rpt/v1, /api/scheduler/migrate/execute, /api/uc/queryLoginMethod/v1, /api/uc/offlineSession/v1, /api/uc/admin/queryAccountInfo/v1, /api/user/getDeviceInfo/v1, /api/oauth/login/v1, /api/uac/login/v1, /api/uac/codeLogin/v1, /api/uac/activate/v1, /api/uac/activatedStatus/v1, /api/ns/*, /api/ping2, /api/uc/login4web/v1, /api/uc/login4app/v1, /api/uc/login4m/v1, /api/uc/register/v1, /api/uc/checkUser/v1, /api/uc/activateUser/v1, /api/uc/resetPassword/v1, /api/account/notice/setOnlineLimit/v1, /api/uc/resetpassword/v2, /api/uc/mobile/resetpassword/v1, /api/uc/resetPassword/v3, /api/playlist/profileMetas/v1, /api/playlist/profilePlaylists/v1, /api/profile/foryou/list/v1, /api/notification/list, /api/notification/listForBanner, /api/oauth/accountExpireTs/v1, /api/media/getPublicPlaySource/v1, /api/media/getCloudSummary/v1, /api/profile/rating/add/v2, /api/profile/rating/query, /api/open/list/v1, /api/open/batchPlaylist/v1, /api/schdule/reload/v1, /api/playlist/sortList/v1, /api/media/playCount/v1";
        return ConfigTools3.getString((String)"vod.token.filter.exclude", (String)defaultTokenFilterExclude);
    }
}

