/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GsonUtils {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(new TypeToken<TreeMap<String, Object>>(){}.getType(), (Object)new JsonDeserializer<TreeMap<String, Object>>(){

        public TreeMap<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            JsonObject jsonObject = json.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                Object ot = entry.getValue();
                if (ot instanceof JsonPrimitive) {
                    treeMap.put((String)entry.getKey(), ((JsonPrimitive)ot).getAsString());
                    continue;
                }
                treeMap.put((String)entry.getKey(), ot);
            }
            return treeMap;
        }
    }).create();
    private static final Type typeToken = new TypeToken<TreeMap<String, Object>>(){}.getType();

    public static <T> String getString(T entity) {
        return gson.toJson(entity);
    }

    public static <T> T getObj(String jsonStr, Class<T> type) {
        return (T)gson.fromJson(jsonStr, type);
    }

    public static <T> List<T> getObjList(String jsonArr, final Class<T> tClass) {
        return (List)gson.fromJson(jsonArr, (Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{tClass};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
    }

    public static <T> Map<String, T> getObjMap(String json, final Class<T> tClass) {
        return (Map)gson.fromJson(json, (Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class, tClass};
            }

            @Override
            public Type getRawType() {
                return Map.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
    }

    public static <T> T getObj(String jsonStr, Type type) {
        return (T)gson.fromJson(jsonStr, type);
    }

    public static <T> Map<String, Object> convertObjToMap(T entity) {
        String jsonStr = gson.toJson(entity);
        return (Map)gson.fromJson(jsonStr, typeToken);
    }

    public static <T> T convertMapToObj(Map<String, String> entity, Class<T> type) {
        String jsonStr = gson.toJson(entity);
        return (T)gson.fromJson(jsonStr, type);
    }

    public static Map<String, Object> getParamsJson(String params) {
        return (Map)gson.fromJson(params, new com.google.common.reflect.TypeToken<Map<String, String>>(){}.getType());
    }

    public static String getStringFromMap(String params, String key) {
        return String.valueOf(GsonUtils.getParamsJson(params).get(key));
    }

    public static Long getLongFromMap(String params, String key) {
        return Long.valueOf(String.valueOf(GsonUtils.getParamsJson(params).get(key)));
    }
}

