/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.common.web.tools.VodIllegalArgumentException;
import com.valor.vod.common.web.tools.VodIllegalStateException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;

public class VodValidate {
    public static void notNull(Object object, String paramName) {
        VodValidate.notNull(object, 3, 250, "The parameter[" + paramName + "] can not be null.");
    }

    public static void notNull(Object object, int retCode, int errCode, String errorMessage) {
        VodValidate.notNull(object, null, null, retCode, errCode, errorMessage);
    }

    public static void notNull(Object object, String language, String deviceId, int retCode, int errCode, String errorMessage) {
        if (object == null) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void notBlank(String chars, String paramName) {
        VodValidate.notBlank(chars, 3, 250, "The parameter[" + paramName + "] can not be empty.");
    }

    public static void notBlank(String chars, int retCode, int errCode, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)chars)) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, retCode, errCode, errorMessage);
        }
    }

    public static void notBlank(String chars, String language, String deviceId, int retCode, int errCode, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)chars)) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void isTrue(boolean expression, int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, retCode, errCode, errorMessage);
        }
    }

    public static void isTrue(boolean expression, String language, String deviceId, int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void checkState(boolean expression, HttpStatus httpStatus, int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalStateException(httpStatus, retCode, errCode, errorMessage);
        }
    }

    public static void checkState(boolean expression, HttpStatus httpStatus, String language, String deviceId, int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalStateException(httpStatus, language, deviceId, retCode, errCode, errorMessage);
        }
    }
}

