package com.valor.vod.common.web.aop.processor;

import com.google.common.base.Strings;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.common.model.token.ServiceToken;
import com.valor.vod.common.tools.http.HttpParameterTools;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.tools.sso.ServiceTokenTools;
import com.valor.vod.common.web.aop.annotation.WebApiCheckServiceToken;
import common.base.tools.exception.ApiException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Frank.Huang on 2017/1/21.
 */
@Aspect
@Service
public class WebApiCheckServiceTokenInterceptorV1 {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCheckServiceTokenInterceptorV1.class);


    @Pointcut(value = "@annotation(com.valor.vod.common.web.aop.annotation.WebApiCheckServiceToken)")
    public void webApiCheckServiceToken() {
    }

    @Before(value = "com.valor.vod.common.web.aop.processor.WebApiCheckServiceTokenInterceptorV1.webApiCheckServiceToken()&&@annotation(wapiCST)")
    public void webApiCheckServiceTokenProcessor(JoinPoint jp, WebApiCheckServiceToken wapiCST) throws ApiException {
        HttpServletRequest request = (HttpServletRequest) jp.getArgs()[0];
        Long appVer = HttpTools.getLongParameter(request, "appVer");
        if (appVer == null) {
            throw new ApiException(HttpCode2.RET_UNSUPPORTED_VERSION, HttpCode2.ERR_VER_IS_EMPTY, "App version is empty.");
        }

        if (appVer <= wapiCST.minSupportAppVer()) {
            logger.info("Version not support Service token.");
            return;
        }

        String st = HttpParameterTools.getParameter(request, "st");
        if (Strings.isNullOrEmpty(st)) {
            logger.warn("Service token is empty");
            throw new ApiException(HttpCode2.RET_BIZ_ERR, HttpCode2.ERR_BIZ_EMPTY_SERVICE_TOKEN, "Service token is empty");
        }

        ServiceToken serviceToken = ServiceTokenTools.decodeServiceToken(st);
        if (serviceToken == null) {
            logger.error("Invalid Service Token(decode error):{}", st);
            throw new ApiException(HttpCode2.RET_BIZ_ERR, HttpCode2.ERR_BIZ_INVALID_SERVICE_TOKEN, "Invalid service token(decode error)");
        }

        String did = HttpParameterTools.getParameter(request, "did");
        if (!did.equalsIgnoreCase(serviceToken.getDid())) {
            logger.error("Invalid Service Token did[{}-{}]", did, serviceToken.getDid());
            throw new ApiException(HttpCode2.RET_BIZ_ERR, HttpCode2.ERR_BIZ_INVALID_SERVICE_TOKEN, "Invalid service token(Forged)");
        }
    }

}
