package com.valor.vod.common.web.crypt.filter;

import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class RequestURLFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestURLFilter.class);

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {

        List<String> uriList = ConfigTools3.getAsList("mfc.meta.eula.redirection.origin.uri", ",");

        String redirctionHost = ConfigTools3.getString("mfc.meta.eula.redirection.target.host", "localhost:9776");

        Iterator iterator = uriList.iterator();
        while (iterator.hasNext()) {
            String url = (String) iterator.next();
            if (request.getRequestURI().equals(url)) {
                response.sendRedirect(redirctionHost + url);
                break;
            }
        }
        filterChain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }

}
