package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.valor.vod.api.common.client.IStringSerializable;

import java.io.UnsupportedEncodingException;
import java.util.Map;

public class TokenV2 implements IStringSerializable {
    public static final int TOKEN_FOR_WEB = 1;
    public static final int TOKEN_FOR_DEVICE = 2;
    public static final int TOKEN_FOR_ACCOUNT = 3;
    public static final int TOKEN_FOR_LOGINCODE = 4;
    public static final int V20170905 = 20170905;
    public static final int V20180808 = 20180808;
    private static final String FIELD_SEPARATOR = "#&#";
    private static final String KV_SEPARATOR = "#=#";
    private Map<Integer, Object> fieldMap = Maps.newTreeMap();

    public TokenV2() {
        put(AuthTokenFiled.VERSION, V20180808);
    }

    public static TokenV2 valueOf(String value) {
        if (Strings.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("[TOKEN2] Empty.");
        }

        if (value.startsWith(String.valueOf(TokenV2.V20170905))) {
            return parseToTokenV2(value);
        }

        Map<String, String> filedDataMap = Splitter.on(FIELD_SEPARATOR).withKeyValueSeparator(KV_SEPARATOR).split(value);
        TokenV2 token = new TokenV2();

        filedDataMap.forEach((k, v) -> {
            AuthTokenFiled filed = AuthTokenFiled.valueOf(Integer.parseInt(k));
            if (filed != null) {
                token.put(filed, TokenFiledTools.getFieldValue(filed.ordinal(), v));
            }
        });


        if (token.getSign() != token.sign()) {
            throw new IllegalArgumentException("[TOKEN2] Invalid Sign");
        }

        return token;
    }

    private static TokenV2 parseToTokenV2(String value) {
        TokenV1 tokenV1 = TokenV1.valueOf(value);
        if (tokenV1 == null) {
            return null;
        }

        TokenV2 tokenV2 = new TokenV2();
        tokenV2.put(AuthTokenFiled.VERSION, tokenV1.getVersion());
        tokenV2.put(AuthTokenFiled.SIGN, tokenV1.getSign());
        tokenV2.put(AuthTokenFiled.CREATE_TIMESTAMP, tokenV1.getGenerateTimestamp());
        tokenV2.put(AuthTokenFiled.EXPIRE_TIMESTAMP, tokenV1.getExpireTimestamp());
        tokenV2.put(AuthTokenFiled.CLIENT_TYPE, tokenV1.getClientType());
        tokenV2.put(AuthTokenFiled.ACCOUNT_TYPE, tokenV1.getLoginType());
        tokenV2.put(AuthTokenFiled.ECHO_STR, tokenV1.getEchoStr());
        tokenV2.put(AuthTokenFiled.ACCOUNT_ID, tokenV1.getAccountId());
        tokenV2.put(AuthTokenFiled.DID, tokenV1.getDid());
        tokenV2.put(AuthTokenFiled.DEVICE_ID, tokenV1.getDid2());
        tokenV2.put(AuthTokenFiled.PROPERTIES, tokenV1.getUserProps());
        return tokenV2;
    }

    public static TokenV2 valueOf(byte[] bytes) {
        return valueOf(new String(bytes));
    }

    public void put(AuthTokenFiled filed, Object fieldValue) {
        fieldMap.put(filed.ordinal(), fieldValue);
    }

    public void put(String filedName, Object fieldValue) {
        AuthTokenFiled filed = AuthTokenFiled.valueOf(filedName);
        if (filed != null) {
            fieldMap.put(filed.ordinal(), fieldValue);
        }
    }

    public Object get(int filedName) {
        return fieldMap.get(filedName);
    }

    public Object get(String filedName) {
        AuthTokenFiled filed = AuthTokenFiled.valueOf(filedName);
        if (filed == null) {
            return null;
        }
        return fieldMap.get(filed.ordinal());
    }

    private String fields2String(Map<Integer, Object> fields) {
        return Joiner.on(FIELD_SEPARATOR).withKeyValueSeparator(KV_SEPARATOR).join(fields);
    }

    private String getSignStr() {
        Map<Integer, Object> map = Maps.newTreeMap();
        fieldMap.forEach((k, v) -> {
            if (AuthTokenFiled.SIGN.ordinal() != k && AuthTokenFiled.PRODUCT_ID.ordinal() != k && AuthTokenFiled.ROOT_NODE_ID.ordinal() != k) {
                map.put(k, v);
            }
        });
        return fields2String(map);
    }

    public long sign() {
        return Hashing.adler32().hashString(getSignStr(), Charsets.UTF_8).padToLong();
    }

    @Override
    public String toSerializeString() {
        fieldMap.put(AuthTokenFiled.SIGN.ordinal(), sign());
        return fields2String(fieldMap);
    }

    @Override
    public byte[] toSerializeBytes() {
        try {
            return toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public long getSign() {
        return (long) fieldMap.getOrDefault(AuthTokenFiled.SIGN.ordinal(), 0L);
    }

    public void setSign(long sign) {
        put(AuthTokenFiled.SIGN, sign());
    }

    public int getVersion() {
        return (int) fieldMap.getOrDefault(AuthTokenFiled.VERSION.ordinal(), 0);
    }

    public void setVersion(int version) {
        put(AuthTokenFiled.VERSION, sign());
    }

    public Long getGenerateTimestamp() {
        return (Long) get(AuthTokenFiled.CREATE_TIMESTAMP.ordinal());
    }

    public void setGenerateTimestamp(Long generateTimestamp) {
        put(AuthTokenFiled.CREATE_TIMESTAMP, generateTimestamp);
    }

    public Long getExpireTimestamp() {
        return (Long) get(AuthTokenFiled.EXPIRE_TIMESTAMP.name());
    }

    public void setExpireTimestamp(Long expireTimestamp) {
        put(AuthTokenFiled.EXPIRE_TIMESTAMP.name(), expireTimestamp);
    }

    public int getClientType() {
        return (int) get(AuthTokenFiled.CLIENT_TYPE.name());
    }

    public void setClientType(int clientType) {
        put(AuthTokenFiled.CLIENT_TYPE.name(), clientType);
    }

    public String getEchoStr() {
        return (String) get(AuthTokenFiled.ECHO_STR.name());
    }

    public void setEchoStr(String echoStr) {
        put(AuthTokenFiled.CLIENT_TYPE.name(), echoStr);
    }

    public int getLoginType() {
        return (int) get(AuthTokenFiled.ACCOUNT_TYPE.name());
    }

    public void setLoginType(int loginType) {
        put(AuthTokenFiled.ACCOUNT_TYPE.name(), loginType);
    }

    public Long getAccountId() {
        return (long) get(AuthTokenFiled.ACCOUNT_ID.name());
    }

    public void setAccountId(Long accountId) {
        put(AuthTokenFiled.ACCOUNT_ID.name(), accountId);
    }

    public Long getSubAccountId() {
        return (long) get(AuthTokenFiled.SUB_ACCOUNT_ID.name());
    }

    public void setSubAccountId(Long accountId) {
        put(AuthTokenFiled.SUB_ACCOUNT_ID.name(), accountId);
    }


    public Long getUserProps() {
        return (long) get(AuthTokenFiled.PROPERTIES.name());
    }

    public void setUserProps(Long userProps) {
        put(AuthTokenFiled.PROPERTIES.name(), userProps);
    }

    public String getDid() {
        return (String) get(AuthTokenFiled.DID.name());
    }

    public void setDid(String did) {
        put(AuthTokenFiled.DID.name(), did);
    }

    public long getDid2() {
        return (long) get(AuthTokenFiled.DEVICE_ID.name());
    }


    public void setDid2(Long deviceId) {
        put(AuthTokenFiled.DEVICE_ID.name(), deviceId);
    }

    public String dump(boolean multiLine) {
        StringBuilder sb = new StringBuilder();
        fieldMap.forEach((k, v) -> {
            if (sb.length() != 0) {
                if (multiLine) {
                    sb.append(System.lineSeparator());
                } else {
                    sb.append("|");
                }
            }

            sb.append(AuthTokenFiled.valueOf(k));
            sb.append("=");
            sb.append(v);
        });

        return sb.toString();
    }

    public Long getProductId() {
        return (long) get(AuthTokenFiled.PRODUCT_ID.name());
    }

    public void setProductId(Long productId) {
        put(AuthTokenFiled.PRODUCT_ID.name(), productId);
    }

    public Long getRootNodeId() {
        return (long) get(AuthTokenFiled.ROOT_NODE_ID.name());
    }

    public void setRootNodeId(Long rootNodeId) {
        put(AuthTokenFiled.ROOT_NODE_ID.name(), rootNodeId);
    }
}
