/*
 * Created by Gabriel Souza on 11/09/18 17:16
 * Copyright Valoroso Ltd. (c) 2018.  All rights reserved.
 */

package com.valor.vod.common.web.http;

import com.google.gson.*;
import com.valor.vod.common.web.http.req.SessionRequestArgs;
import com.valor.vod.common.web.util.HttpConnectionFactory;
import common.base.tools.api.model.ApiBaseResponse;
import common.config.tools.config.ConfigTools3;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import javax.annotation.PostConstruct;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@Service
public class CommonServiceApi {

    private static final Logger logger = LoggerFactory.getLogger(CommonServiceApi.class);
    private CommonServiceApiInterface commonServiceApiInterface;
    private Gson gson;

    @PostConstruct
    private void init() {
        GsonBuilder builder = new GsonBuilder();

        builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() {
            @Override
            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
//                json.
                return new Date(json.getAsJsonPrimitive().getAsLong());
            }
        });

        gson = builder.create();

        OkHttpClient okHttpClient = HttpConnectionFactory.getClient();
        logger.info("[CommonServiceApi] vod.commonservice.api.host[{}]", ConfigTools3.getConfigAsString("vod.commonservice.api.host"));
        Retrofit retrofit = new Retrofit.Builder().baseUrl(ConfigTools3.getConfigAsString("vod.commonservice.api.host")).client(okHttpClient)
            .addConverterFactory(GsonConverterFactory.create(gson)).build();
        commonServiceApiInterface = retrofit.create(CommonServiceApiInterface.class);

    }

    public ApiBaseResponse checkSession(long accountId, int accountType, String clientSession, Map<String, String> extParam) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setExtParam(extParam);
        try {
            ApiBaseResponse response = commonServiceApiInterface.checkSession(
                args
            ).execute().body();
            if (Objects.nonNull(response)) {
                if(!response.isSuccessful()){
                    logger.info("Query User Session failure, errorBody[{}]",
                        StringUtils.isNotBlank(response.getMessage()) ? response.getMessage() : null);
                }
            }
            return response;
        } catch (Exception e) {
            logger.error("Query User Notic error", e);
        }
        return null;
    }

    public ApiBaseResponse updateSubAccountName(long accountId, int accountType, String clientSession, String subAccountName) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setSubAccountName(subAccountName);
        try {
            ApiBaseResponse response = commonServiceApiInterface.updateSubAccountName(
                args
            ).execute().body();
            if (Objects.nonNull(response)) {
                if(!response.isSuccessful()){
                    logger.info("Update User Session failure, errorBody[{}]",
                        StringUtils.isNotBlank(response.getMessage()) ? response.getMessage() : null);
                }
            }
            return response;
        } catch (Exception e) {
            logger.error("Update User Notic error", e);
        }
        return null;
    }

    public ApiBaseResponse updateSubAccountId(long accountId, int accountType, String clientSession, Long subAccountId) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setSubAccountId(subAccountId);
        try {
            ApiBaseResponse response = commonServiceApiInterface.updateSubAccountId(
                args
            ).execute().body();
            if (Objects.nonNull(response)) {
                if(!response.isSuccessful()){
                    logger.info("Update User Session failure, errorBody[{}]",
                        StringUtils.isNotBlank(response.getMessage()) ? response.getMessage() : null);
                }
            }
            return response;
        } catch (Exception e) {
            logger.error("Update User Notic error", e);
        }
        return null;
    }

}
