package com.valor.vod.common.web.tools;

import com.valor.vod.api.model.constant.response.HttpCode2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;

/**
 * @author Tom Tang
 * @date 2022/11/14
 */
public class VodValidate {

    public static void notNull(final Object object, String paramName) {
        notNull(object, HttpCode2.RET_INVALID_PARAM, HttpCode2.ERR_PARAM_INVALID,
            "The parameter[" + paramName + "] can not be null.");
    }

    public static void notNull(final Object object, int retCode, int errCode, String errorMessage) {
        notNull(object, null, null, retCode, errCode, errorMessage);
    }

    public static void notNull(final Object object, String language, String deviceId,
                               int retCode, int errCode, String errorMessage) {
        if (object == null) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void notBlank(final String chars, String paramName) {
        notBlank(chars, HttpCode2.RET_INVALID_PARAM, HttpCode2.ERR_PARAM_INVALID,
            "The parameter[" + paramName + "] can not be empty.");
    }

    public static void notBlank(final String chars, int retCode, int errCode, String errorMessage) {
        if (StringUtils.isBlank(chars)) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, retCode, errCode, errorMessage);
        }
    }

    public static void notBlank(final String chars, String language, String deviceId,
                                int retCode, int errCode, String errorMessage) {
        if (StringUtils.isBlank(chars)) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void isTrue(boolean expression, int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, retCode, errCode, errorMessage);
        }
    }

    public static void isTrue(boolean expression, String language, String deviceId,
                              int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalArgumentException(HttpStatus.BAD_REQUEST, language, deviceId, retCode, errCode, errorMessage);
        }
    }

    public static void checkState(boolean expression, HttpStatus httpStatus,
                                  int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalStateException(httpStatus, retCode, errCode, errorMessage);
        }
    }

    public static void checkState(boolean expression, HttpStatus httpStatus, String language, String deviceId,
                                  int retCode, int errCode, String errorMessage) {
        if (!expression) {
            throw new VodIllegalStateException(httpStatus, language, deviceId, retCode, errCode, errorMessage);
        }
    }
}
