/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.common.web.aop.annotation.ExceptionConverter;
import com.valor.vod.common.web.tools.BusinessException;
import com.valor.vod.common.web.tools.VodException;
import common.base.tools.exception.ApiException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExceptionConverterAspect {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConverterAspect.class);

    @AfterThrowing(throwing="e", pointcut="@annotation(com.valor.vod.common.web.aop.annotation.ExceptionConverter)")
    public void convertException(JoinPoint joinPoint, Throwable e) throws Throwable {
        this.checkOriginalException(joinPoint, e);
        this.convert(joinPoint, e);
    }

    private void checkOriginalException(JoinPoint joinPoint, Throwable e) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        ExceptionConverter annotation = method.getAnnotation(ExceptionConverter.class);
        Class<? extends Throwable> originalExceptionClass = annotation.originalException();
        if (e instanceof VodException || e instanceof ApiException || e instanceof BusinessException || e instanceof UndeclaredThrowableException || !originalExceptionClass.isInstance(e)) {
            throw e;
        }
    }

    private void convert(JoinPoint joinPoint, Throwable e) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        ExceptionConverter annotation = method.getAnnotation(ExceptionConverter.class);
        if (annotation.logException()) {
            log.error(this.getWholeErrorMessage(annotation.errorMessage(), method, joinPoint.getArgs()), e);
        }
        throw new VodException(annotation.httpStatus(), annotation.retCode(), annotation.errorCode(), annotation.errorMessage());
    }

    private String getWholeErrorMessage(String annotationErrorMessage, Method method, Object[] args) {
        String initialErrorMessage = StringUtils.isEmpty((CharSequence)annotationErrorMessage) ? method.getName() + " failed." : annotationErrorMessage;
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        if (parameterNames == null || parameterNames.length == 0) {
            return initialErrorMessage;
        }
        StringBuilder errorMessageBuilder = new StringBuilder(initialErrorMessage.length() + 64).append(initialErrorMessage);
        for (int i = 0; i < parameterNames.length; ++i) {
            errorMessageBuilder.append(' ').append(parameterNames[i]).append('[').append(args[i]).append("]").append(i == parameterNames.length - 1 ? (char)'.' : ',');
        }
        return errorMessageBuilder.toString();
    }
}

