/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.filter.sso;

import com.valor.vod.api.common.encrypt.RSABase64Utils;
import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.common.web.filter.sso.AuthTokenFiled;
import com.valor.vod.common.web.filter.sso.TokenV1;
import com.valor.vod.common.web.filter.sso.TokenV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOTools {
    private static final Logger logger = LoggerFactory.getLogger(SSOTools.class);

    public static String encodeToken(TokenV2 token, String ASPrivateKey) {
        if (token == null) {
            return "";
        }
        try {
            return RSABase64Utils.encriptByPrivateKey((byte[])token.toSerializeString().getBytes(), (String)ASPrivateKey);
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return "";
        }
    }

    public static TokenV2 decodeToken(String tokenStr, String ASKey) {
        try {
            byte[] bytesToken = RSABase64Utils.decryptByPublicKey((String)tokenStr, (String)ASKey);
            return TokenV2.valueOf(new String(bytesToken));
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sign(String data, String ASPrivateKey) {
        try {
            String string = RSABase64Utils.sign((String)data, (String)ASPrivateKey);
            return string;
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            String string = "";
            return string;
        }
    }

    public static String encodeTokenV1(TokenV1 token, String ASPrivateKey) {
        if (token == null) {
            return "";
        }
        try {
            return RSABase64Utils.encriptByPrivateKey((byte[])token.toSerializeString().getBytes(), (String)ASPrivateKey);
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return "";
        }
    }

    public static TokenV1 decodeTokenV1(String tokenStr, String ASKey) {
        try {
            byte[] bytesToken = RSABase64Utils.decryptByPublicKey((String)tokenStr, (String)ASKey);
            return TokenV1.valueOf(new String(bytesToken));
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return null;
        }
    }

    public static void main(String[] args) {
        TokenV2 token = new TokenV2();
        token.setAccountId(173L);
        token.setDid("");
        token.setDid2(-1L);
        token.setUserProps(1L);
        token.setGenerateTimestamp(System.currentTimeMillis());
        token.setClientType(1);
        token.setExpireTimestamp(token.getGenerateTimestamp() + 86400000L);
        token.put(AuthTokenFiled.ACCOUNT_TYPE.name(), (Object)EAccountType.ACCOUNT.getCode());
        token.put(AuthTokenFiled.CLIENT_SESSION.name(), (Object)"");
        String ASPrivateKey = "MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAwGCwSnyaNqkT2dN866ZrJ0n5xzO7F5BJehXER6v2k3Ad9eDsCJBXZlZreizZXRjBYzt-naoL-9kHbg-0LSzilwIDAQABAkEAjyplh8la6rrBLyYYnTZoIAEJhZmV7l9OjzCLtdrf0bAdDU6zLg_StZeKSdw8byaeSd5MNMSXB-3Fx57lGGU7QQIhAP3pQ-fElTPrhrAPk3gPm5wKBCMNjzpSyf6jGkW5FA7ZAiEAwfXVmO6Ir-7n1fKTIeDHQMQqPtiDvD36B5wXxs6Tdu8CIE71ZyR_wVYv--ZsMZO4Zs-TXc34vX2JmT8SQW1FLLOhAiAOnH9XwvhnEH9Efb6Zub4o4d4w18ysvJp-QkMERgGT3wIhAKgyzmKSA8VDDrSWZ74jEJKkhLklegc6obkn26zkHgT0";
        String s = SSOTools.encodeToken(token, ASPrivateKey);
        System.out.println(s);
    }
}

