/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.valor.vod.api.common.client.IStringSerializable;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class TokenV1
implements IStringSerializable {
    public static final int TOKEN_FOR_WEB = 1;
    public static final int TOKEN_FOR_DEVICE = 2;
    public static final int TOKEN_FOR_ACCOUNT = 3;
    private static final String FIELD_SEPARATOR = "#!";
    private static final int VERSION_20170905 = 20170905;
    private static final int VERSION_20170905_FIELD_SIZE = 11;
    private static final int INDEX_VERSION = 0;
    private static final int INDEX_SIGN = 1;
    private static final int INDEX_GENERATE_TIMESTAMP = 2;
    private static final int INDEX_EXPIRE_TIMESTAMP = 3;
    private static final int INDEX_CLIENT_TYPE = 4;
    private static final int INDEX_LOGIN_TYPE = 5;
    private static final int INDEX_ECHOSTR = 6;
    private static final int INDEX_ACCOUNT_ID = 7;
    private static final int INDEX_USERPROPS = 8;
    private static final int INDEX_DID = 9;
    private static final int INDEX_DID2 = 10;
    private int version = 20170905;
    private Long sign = 0L;
    private Long generateTimestamp = System.currentTimeMillis();
    private Long expireTimestamp = System.currentTimeMillis();
    private int clientType = 0;
    private int loginType = 0;
    private String echoStr = "";
    private Long accountId = 0L;
    private Long userProps = 0L;
    private String did = "";
    private Long did2 = 0L;

    public static TokenV1 valueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("[TOKEN2] Empty.");
        }
        List valueList = Splitter.on((String)FIELD_SEPARATOR).splitToList((CharSequence)value);
        if (valueList.size() < 2) {
            throw new IllegalArgumentException("[TOKEN2] Invalid Content");
        }
        TokenV1 token = new TokenV1();
        token.version = Integer.valueOf((String)valueList.get(0));
        if (token.version == 20170905 && valueList.size() != 11) {
            throw new IllegalArgumentException("[TOKEN2] Invalid Content 2");
        }
        token.sign = Long.valueOf((String)valueList.get(1));
        token.generateTimestamp = Long.valueOf((String)valueList.get(2));
        token.expireTimestamp = Long.valueOf((String)valueList.get(3));
        token.clientType = Integer.valueOf((String)valueList.get(4));
        token.loginType = Integer.valueOf((String)valueList.get(5));
        token.echoStr = (String)valueList.get(6);
        token.accountId = Long.valueOf((String)valueList.get(7));
        token.userProps = Long.valueOf((String)valueList.get(8));
        token.did = (String)valueList.get(9);
        token.did2 = Long.valueOf((String)valueList.get(10));
        if (token.sign.longValue() != token.sign()) {
            throw new IllegalArgumentException("[TOKEN2] Invalid SignTools");
        }
        return token;
    }

    public static TokenV1 valueOf(byte[] bytes) {
        return TokenV1.valueOf(new String(bytes));
    }

    private String getSignStr() {
        return Joiner.on((String)FIELD_SEPARATOR).join((Object)this.version, (Object)this.generateTimestamp, new Object[]{this.expireTimestamp, this.clientType, this.loginType, this.echoStr, this.accountId, this.userProps, this.did, this.did2});
    }

    public long sign() {
        return Hashing.sha256().hashString((CharSequence)this.getSignStr(), Charsets.UTF_8).padToLong();
    }

    public String toSerializeString() {
        this.sign = this.sign();
        return Joiner.on((String)FIELD_SEPARATOR).useForNull("0").join((Object)this.version, (Object)this.sign, new Object[]{this.generateTimestamp, this.expireTimestamp, this.clientType, this.loginType, this.echoStr, this.accountId, this.userProps, this.did, this.did2});
    }

    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return new byte[0];
        }
    }

    public long getSign() {
        return this.sign;
    }

    public void setSign(long sign) {
        this.sign = sign;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Long getGenerateTimestamp() {
        return this.generateTimestamp;
    }

    public void setGenerateTimestamp(Long generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    public Long getExpireTimestamp() {
        return this.expireTimestamp;
    }

    public void setExpireTimestamp(Long expireTimestamp) {
        this.expireTimestamp = expireTimestamp;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getEchoStr() {
        return this.echoStr;
    }

    public void setEchoStr(String echoStr) {
        this.echoStr = echoStr;
    }

    public int getLoginType() {
        return this.loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getUserProps() {
        return this.userProps;
    }

    public void setUserProps(Long userProps) {
        this.userProps = userProps;
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public long getDid2() {
        return this.did2;
    }

    public void setDid2(Long did2) {
        this.did2 = did2;
    }

    public void setDid2(long did2) {
        this.did2 = did2;
    }
}

