/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.valor.vod.common.web.http.CommonServiceApiInterface;
import com.valor.vod.common.web.http.req.SessionRequestArgs;
import com.valor.vod.common.web.util.HttpConnectionFactory;
import common.base.tools.api.model.ApiBaseResponse;
import common.config.tools.config.ConfigTools3;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CommonServiceApi {
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceApi.class);
    private CommonServiceApiInterface commonServiceApiInterface;
    private Gson gson;

    @PostConstruct
    private void init() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Date(json.getAsJsonPrimitive().getAsLong());
            }
        });
        this.gson = builder.create();
        OkHttpClient okHttpClient = HttpConnectionFactory.getClient();
        logger.info("[CommonServiceApi] vod.commonservice.api.host[{}]", (Object)ConfigTools3.getConfigAsString((String)"vod.commonservice.api.host"));
        Retrofit retrofit = new Retrofit.Builder().baseUrl(ConfigTools3.getConfigAsString((String)"vod.commonservice.api.host")).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).build();
        this.commonServiceApiInterface = (CommonServiceApiInterface)retrofit.create(CommonServiceApiInterface.class);
    }

    public ApiBaseResponse checkSession(long accountId, int accountType, String clientSession, Map<String, String> extParam) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setExtParam(extParam);
        try {
            ApiBaseResponse response = (ApiBaseResponse)this.commonServiceApiInterface.checkSession(args).execute().body();
            if (Objects.nonNull(response) && !response.isSuccessful()) {
                logger.info("Query User Session failure, errorBody[{}]", (Object)(StringUtils.isNotBlank((CharSequence)response.getMessage()) ? response.getMessage() : null));
            }
            return response;
        }
        catch (Exception e2) {
            logger.error("Query User Notic error", (Throwable)e2);
            return null;
        }
    }

    public ApiBaseResponse updateSubAccountName(long accountId, int accountType, String clientSession, String subAccountName) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setSubAccountName(subAccountName);
        try {
            ApiBaseResponse response = (ApiBaseResponse)this.commonServiceApiInterface.updateSubAccountName(args).execute().body();
            if (Objects.nonNull(response) && !response.isSuccessful()) {
                logger.info("Update User Session failure, errorBody[{}]", (Object)(StringUtils.isNotBlank((CharSequence)response.getMessage()) ? response.getMessage() : null));
            }
            return response;
        }
        catch (Exception e2) {
            logger.error("Update User Notic error", (Throwable)e2);
            return null;
        }
    }

    public ApiBaseResponse updateSubAccountId(long accountId, int accountType, String clientSession, Long subAccountId) {
        SessionRequestArgs args = new SessionRequestArgs();
        args.setAccountId(accountId);
        args.setAccountType(accountType);
        args.setClientSession(clientSession);
        args.setSubAccountId(subAccountId);
        try {
            ApiBaseResponse response = (ApiBaseResponse)this.commonServiceApiInterface.updateSubAccountId(args).execute().body();
            if (Objects.nonNull(response) && !response.isSuccessful()) {
                logger.info("Update User Session failure, errorBody[{}]", (Object)(StringUtils.isNotBlank((CharSequence)response.getMessage()) ? response.getMessage() : null));
            }
            return response;
        }
        catch (Exception e2) {
            logger.error("Update User Notic error", (Throwable)e2);
            return null;
        }
    }
}

