/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.common.web.tools.ErrorMsgBuilder;
import org.springframework.http.HttpStatus;

public class VodException
extends RuntimeException {
    private HttpStatus httpStatus;
    private String language = "en";
    private String deviceId;
    private final int retCode;
    private final int errCode;
    private boolean useDefaultMsg;

    public VodException(int retCode, int errCode) {
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(int retCode, int errCode, String errorMessage) {
        super(errorMessage);
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(int retCode, int errCode, Throwable cause) {
        super(cause);
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(int retCode, int errCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(HttpStatus httpStatus, int retCode, int errCode) {
        this.httpStatus = httpStatus;
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(HttpStatus httpStatus, int retCode, int errCode, String errorMessage) {
        super(errorMessage);
        this.httpStatus = httpStatus;
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(HttpStatus httpStatus, int retCode, int errCode, Throwable cause) {
        super(cause);
        this.httpStatus = httpStatus;
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(HttpStatus httpStatus, int retCode, int errCode, String errorMessage, Throwable cause) {
        this(httpStatus, null, null, retCode, errCode, errorMessage, cause);
    }

    public VodException(HttpStatus httpStatus, String language, int retCode, int errCode, String errorMessage) {
        this(httpStatus, language, null, retCode, errCode, errorMessage);
    }

    public VodException(HttpStatus httpStatus, String language, String deviceId, int retCode, int errCode, String errorMessage) {
        super(errorMessage);
        this.httpStatus = httpStatus;
        this.language = language;
        this.deviceId = deviceId;
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public VodException(HttpStatus httpStatus, String language, int retCode, int errCode, String errorMessage, Throwable cause) {
        this(httpStatus, language, null, retCode, errCode, errorMessage, cause);
    }

    public VodException(HttpStatus httpStatus, String language, String deviceId, int retCode, int errCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.httpStatus = httpStatus;
        this.language = language;
        this.deviceId = deviceId;
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public String buildMessage() {
        if (this.useDefaultMsg) {
            return ErrorMsgBuilder.spliceErrMsg(this.deviceId, this.retCode, this.errCode, this.getMessage());
        }
        return ErrorMsgBuilder.buildErrMsg(this.language, this.deviceId, this.retCode, this.errCode, this.getMessage());
    }

    public static VodExceptionBuilder builder() {
        return new VodExceptionBuilder();
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public int getRetCode() {
        return this.retCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public boolean isUseDefaultMsg() {
        return this.useDefaultMsg;
    }

    public static class VodExceptionBuilder {
        private HttpStatus httpStatus;
        private String language = "en";
        private String deviceId;
        private int retCode;
        private int errCode;
        private boolean useDefaultMsg;
        private String message;
        private Throwable cause;

        public VodException build() {
            VodException vodException = this.cause == null ? new VodException(this.retCode, this.errCode, this.message) : new VodException(this.retCode, this.errCode, this.message, this.cause);
            vodException.httpStatus = this.httpStatus;
            vodException.language = this.language;
            vodException.deviceId = this.deviceId;
            vodException.useDefaultMsg = this.useDefaultMsg;
            return vodException;
        }

        public VodExceptionBuilder httpStatus(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public VodExceptionBuilder language(String language) {
            this.language = language;
            return this;
        }

        public VodExceptionBuilder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public VodExceptionBuilder retCode(int retCode) {
            this.retCode = retCode;
            return this;
        }

        public VodExceptionBuilder errCode(int errCode) {
            this.errCode = errCode;
            return this;
        }

        public VodExceptionBuilder useDefaultMsg(boolean useDefaultMsg) {
            this.useDefaultMsg = useDefaultMsg;
            return this;
        }

        public VodExceptionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public VodExceptionBuilder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }
    }
}

