/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.ErrorMsgBuilder;
import com.valor.vod.common.web.tools.BusinessException;
import com.valor.vod.common.web.tools.VodException;
import com.valor.vod.common.web.tools.VodIllegalArgumentException;
import com.valor.vod.common.web.tools.VodIllegalStateException;
import com.valor.vod.common.web.util.TraceUtils;
import common.base.tools.exception.ApiException;
import java.lang.reflect.UndeclaredThrowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ConditionalOnMissingBean(annotation={ExceptionHandler.class})
@ControllerAdvice
public class VodExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(VodExceptionHandler.class);
    private static final int VOD_ERROR_STATUS = 555;

    @ExceptionHandler(value={Throwable.class})
    private ResponseEntity<ResponseStatus> handThrowable(WebRequest request, Throwable e2) {
        log.error("An internal exception occurred. req:{}.", (Object)request, (Object)e2);
        ResponseStatus errorResponse = new ResponseStatus();
        errorResponse.setStatus(1, 101, "Internal Server Error.");
        errorResponse.setErrMessage("Internal Server Error.");
        this.setAndRemoveTraceId(errorResponse);
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    private ResponseEntity<ResponseStatus> handIllegalArgumentException(IllegalArgumentException e2) {
        log.warn("[Bad Request]", (Throwable)e2);
        String errMsg = ErrorMsgBuilder.buildErrMsgNotAppendCode(null, null, (int)3, (int)250, (String)e2.getMessage());
        ResponseStatus errorResponse = new ResponseStatus();
        errorResponse.setStatus(3, 250, errMsg);
        errorResponse.setErrMessage(errMsg);
        this.setAndRemoveTraceId(errorResponse);
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={VodIllegalArgumentException.class, VodIllegalStateException.class})
    private ResponseEntity<ResponseStatus> handVodIllegalException(VodException e2) {
        log.warn("[Bad Request]", (Throwable)e2);
        return ResponseEntity.status((int)555).body((Object)this.buildResponseStatus(e2));
    }

    @ExceptionHandler(value={VodException.class})
    private ResponseEntity<ResponseStatus> handVodException(VodException e2) {
        return ResponseEntity.status((int)555).body((Object)this.buildResponseStatus(e2));
    }

    private ResponseStatus buildResponseStatus(VodException e2) {
        ResponseStatus errorResponse = new ResponseStatus();
        String errorMessage = ErrorMsgBuilder.buildErrMsgNotAppendCode((String)e2.getLanguage(), (String)e2.getDeviceId(), (int)e2.getRetCode(), (int)e2.getErrCode(), (String)e2.getMessage());
        errorResponse.setStatus(e2.getRetCode(), e2.getErrCode(), errorMessage);
        errorResponse.setErrMessage(errorMessage);
        this.setAndRemoveTraceId(errorResponse);
        return errorResponse;
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    private ResponseEntity<ResponseStatus> handVodException(WebRequest request, UndeclaredThrowableException e2) {
        Throwable undeclaredThrowable = e2.getUndeclaredThrowable();
        if (undeclaredThrowable instanceof ApiException) {
            return this.handApiException((ApiException)undeclaredThrowable);
        }
        if (undeclaredThrowable instanceof BusinessException) {
            return this.handBusinessException((BusinessException)undeclaredThrowable);
        }
        if (undeclaredThrowable instanceof VodException) {
            return this.handVodException((VodException)undeclaredThrowable);
        }
        return this.handThrowable(request, undeclaredThrowable);
    }

    @ExceptionHandler(value={ApiException.class})
    private ResponseEntity<ResponseStatus> handApiException(ApiException e2) {
        log.warn("A api exception occurred.", (Throwable)e2);
        ResponseStatus errorResponse = new ResponseStatus();
        String errorMessage = ErrorMsgBuilder.buildErrMsgNotAppendCode(null, null, (int)e2.getRetCode(), (int)e2.getErrCode(), (String)"Internal Server Error.");
        errorResponse.setStatus(e2.getRetCode(), e2.getErrCode(), errorMessage);
        errorResponse.setErrMessage(errorMessage);
        this.setAndRemoveTraceId(errorResponse);
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={BusinessException.class})
    private ResponseEntity<ResponseStatus> handBusinessException(BusinessException e2) {
        log.warn("A business exception occurred.", (Throwable)e2);
        ResponseStatus errorResponse = new ResponseStatus();
        String errorMessage = ErrorMsgBuilder.buildErrMsgNotAppendCode(null, null, (int)e2.getRetCode(), (int)e2.getErrCode(), (String)e2.getMessage());
        errorResponse.setStatus(e2.getRetCode(), e2.getErrCode(), errorMessage);
        errorResponse.setErrMessage(errorMessage);
        this.setAndRemoveTraceId(errorResponse);
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    private void setAndRemoveTraceId(ResponseStatus errorResponse) {
        errorResponse.setTraceId(TraceUtils.getTraceId());
        TraceUtils.removeTraceId();
    }
}

