/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.util;

import common.config.tools.config.ConfigTools3;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class HttpConnectionFactory {
    private HttpConnectionFactory() {
        throw new IllegalStateException("Utility class");
    }

    private static int getHttpClientTimeout() {
        return ConfigTools3.getInt((String)"httpclient.timeout", (Integer)60000);
    }

    private static int getHttpClientRetries() {
        return ConfigTools3.getInt((String)"httpclient.retries", (Integer)2);
    }

    public static OkHttpClient getClient() {
        return new OkHttpClient.Builder().readTimeout((long)HttpConnectionFactory.getHttpClientTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).connectTimeout((long)HttpConnectionFactory.getHttpClientTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public static OkHttpClient getAuthenticatedClient(String username, String password) {
        return new OkHttpClient.Builder().readTimeout((long)HttpConnectionFactory.getHttpClientTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).connectTimeout((long)HttpConnectionFactory.getHttpClientTimeout(), TimeUnit.MILLISECONDS).authenticator((route, response) -> {
            String credential = Credentials.basic((String)username, (String)password);
            if (HttpConnectionFactory.responseCount(response) > HttpConnectionFactory.getHttpClientRetries()) {
                return null;
            }
            return response.request().newBuilder().header("Authorization", credential).build();
        }).build();
    }

    private static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }
}

