package com.valor.vod.common.web.LAC;

import com.comnon.lac.LACTools;

import common.base.tools.stat.MetricTools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Created by Frank.Huang on 2017/6/30. */
public class LAC {
    private static final Logger logger = LoggerFactory.getLogger(LAC.class);

    static {
        LACTools.loadGeoDB("config/GeoLite2-City.mmdb");
        LACTools.loaderCfg("config", "mfc-lac.json", 5 * 60 * 1000);
    }

    public static boolean isLocationPermit(String did, String clientIp, String clientRegion) {
        boolean isPermit = LACTools.isHostPermit(did, clientIp, clientRegion);
        logger.info(
                "[LAC] did[{}] clientIP[{}] clientRegion[{}] permit[{}]",
                did,
                clientIp,
                clientRegion,
                isPermit);
        MetricTools.reportLAC(did, clientIp, clientRegion, isPermit);

        if (LACTools.isACLEnable()) {
            return isPermit;
        } else {
            return true;
        }
    }
}
