package com.valor.vod.common.web.aop.annotation;

import com.valor.vod.common.web.configuration.ErrorCodeScannerConfigurer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Bruce Wu
 * @since 2023-03-06
 */
public class ErrorCodeScannerRegistrar implements ImportBeanDefinitionRegistrar, BeanFactoryAware {

    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void registerBeanDefinitions(
            AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annoAttrs =
                AnnotationAttributes.fromMap(
                        importingClassMetadata.getAnnotationAttributes(
                                ErrorCodeScan.class.getName()));
        List<String> basePackages = new ArrayList<>();
        if (annoAttrs != null) {
            basePackages.addAll(
                    Arrays.stream(annoAttrs.getStringArray("basePackages"))
                            .filter(StringUtils::hasText)
                            .collect(Collectors.toList()));
            if (basePackages.isEmpty()) {
                basePackages.add(ClassUtils.getPackageName(importingClassMetadata.getClassName()));
            }
        } else {
            if (!AutoConfigurationPackages.has(this.beanFactory)) {
                return;
            }
            List<String> packages = AutoConfigurationPackages.get(this.beanFactory);
            basePackages.addAll(packages);
        }

        String beanName = generateBaseBeanName(importingClassMetadata, 0);
        BeanDefinitionBuilder builder =
                BeanDefinitionBuilder.genericBeanDefinition(ErrorCodeScannerConfigurer.class);

        builder.addPropertyValue(
                "basePackage", StringUtils.collectionToCommaDelimitedString(basePackages));

        registry.registerBeanDefinition(beanName, builder.getBeanDefinition());
    }

    private static String generateBaseBeanName(
            AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName()
                + "#"
                + ErrorCodeScannerRegistrar.class.getSimpleName()
                + "#"
                + index;
    }
}
