package com.valor.vod.common.web.aop.annotation;

import com.valor.vod.api.model.constant.response.HttpCode2;

import org.springframework.http.HttpStatus;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 异常转换注解
 *
 * @author Tom Tang
 * @date 2021/8/3
 * @since 3.0.0
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExceptionConverter {

    Class<? extends Throwable> originalException() default Throwable.class;

    HttpStatus httpStatus() default HttpStatus.INTERNAL_SERVER_ERROR;

    int retCode() default HttpCode2.RET_SYS_EXCEPTION;

    int errorCode() default HttpCode2.ERR_SYS_EXCEPTION;

    String errorMessage() default "Internal Server Error.";

    boolean logException() default true;
}
