package com.valor.vod.common.web.aop.processor;

import com.valor.vod.common.web.tools.GsonUtils;
import com.valor.vod.common.web.tools.VodException;

import common.base.tools.exception.ApiException;

import lombok.extern.slf4j.Slf4j;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 * @author Bruce Wu
 * @since 2022-11-15
 */
@Aspect
@Slf4j
public class RequestClientAspect {

    @Pointcut(
            "@annotation(com.valor.vod.common.web.aop.annotation.RequestClient) "
                    + "|| @within(com.valor.vod.common.web.aop.annotation.RequestClient)")
    public void pointcut() {}

    @Around(value = "pointcut()")
    public Object requestClient(ProceedingJoinPoint pjp) throws Throwable {
        String methodName = pjp.getSignature().getName();
        Object[] args = pjp.getArgs();
        Object response = null;
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            response = pjp.proceed();
        } catch (Exception e) {
            ex = e;
        }
        if (ex != null) {
            if (ex instanceof VodException) {
                VodException vodEx = (VodException) ex;
                String codeMsg =
                        String.format(
                                "retCode=%d errCode=%d errMessage=%s",
                                vodEx.getRetCode(), vodEx.getErrCode(), vodEx.getMessage());
                log.error("client-err: method=>[{}] request={} {}", methodName, args, codeMsg);
            } else if (ex instanceof ApiException) {
                ApiException apiEx = (ApiException) ex;
                String codeMsg =
                        String.format(
                                "retCode=%d errCode=%d errMessage=%s",
                                apiEx.getRetCode(), apiEx.getErrCode(), apiEx.getMessage());
                log.error("client-err: method=>[{}] request={} {}", methodName, args, codeMsg);
            } else {
                log.error("client-err: method=>[{}] request={} ", methodName, args, ex);
            }
            throw ex;
        }

        long endTime = System.currentTimeMillis();
        log.info(
                "client-suc: method=>[{}], request={}, response={} cost={}",
                methodName,
                args,
                GsonUtils.getString(response),
                endTime - startTime);

        return response;
    }
}
