package com.valor.vod.common.web.aop.processor;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.api.model.user.DeviceDto;
import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.constant.VodHttpAttr;
import com.valor.vod.common.web.http.CommonServiceApi;
import com.valor.vod.common.web.model.BaseResponse;
import com.valor.vod.common.web.request.BaseRequestArgs;
import com.valor.vod.common.web.tools.VodHttpContext;
import common.base.tools.api.model.ApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * @author murphy
 * @Description: SDK验证session是否失效，did + cpuId + androidId + imeiId
 **/
@Aspect
@Order(2)
public class VerifySDKSessionInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(VerifySessionInterceptor.class);

    private static final String MOBILE = "mobile";

    private static final String BOX = "box";

    @Autowired
    private CommonServiceApi commonServiceApi;


    @Pointcut(value = "@annotation(com.valor.vod.common.web.aop.annotation.VerifySDKSession)")
    public void verifySDKSession() {
    }

    @Around("com.valor.vod.common.web.aop.processor.VerifySDKSessionInterceptor.verifySDKSession()")
    public Object doVerifySession(ProceedingJoinPoint pjp) throws Throwable {
        Object args = getArgs(pjp);
        Object proceed = pjp.proceed();
        String clientSession = VodHttpContext.getContext().getString(VodHttpAttr.CLIENT_SESSION);

        Long accountId = VodHttpContext.getContext().getLong(VodHttpAttr.ACCOUNT_ID);
        String appId = VodHttpContext.getContext().getString(VodHttpAttr.APP_ID);
        int accountType = VodHttpContext.getContext().getInteger(VodHttpAttr.ACCOUNT_TYPE);

        if (Objects.nonNull(args) && StringUtils.isNotEmpty(appId) && appId.equalsIgnoreCase("mfc-kids")) {
            if (isAppRequest()) {

            } else {
                logger.info("Kids account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ",
                        accountId, accountType, clientSession,isAppRequest(), accountType == EAccountType.DEVICE.getCode());
            }
        } else {
            if (isAppRequest()) {

                ApiBaseResponse result = commonServiceApi.checkSession(accountId, accountType, clientSession, null);
                if (result.getErrCode() != 0) {
                    if (proceed instanceof BaseResponse) {
                        BaseResponse responseStatus = (BaseResponse) proceed;
                        responseStatus.setCode(SystemErrorCodes.SESSION_OFFLINE.getCode());
                        responseStatus.setMsg(SystemErrorCodes.SESSION_OFFLINE.getDesc());
                    }
                    logger.info("Account[{}] accountType[{}] session[{}] , session is not online ", accountId, accountType, clientSession);
                } else {
                    logger.debug("Account[{}] accountType[{}] session[{}] , session is online ", accountId, accountType, clientSession);
                }

            } else {
                logger.info("Account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ",
                        accountId, accountType, clientSession, isAppRequest(), accountType == EAccountType.DEVICE.getCode());
            }
        }
        return proceed;
    }


    public Object getArgs(JoinPoint jp) {
        Object arg = null;
        if (jp.getArgs().length >= 3) {
            arg = jp.getArgs()[2];
            return arg;
        }
        return null;
    }

    private boolean isAppRequest() {
        String appId = VodHttpContext.getContext().getString(VodHttpAttr.APP_ID);
        if (StringUtils.isEmpty(appId)) {
            return false;
        } else if (appId.equalsIgnoreCase(MOBILE) || appId.equalsIgnoreCase(BOX)) {
            return true;
        }
        return false;
    }
}
