package com.valor.vod.common.web.aop.processor;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.common.web.http.CommonServiceApi;
import com.valor.vod.common.web.request.BaseRequestArgs;

import common.base.tools.api.model.ApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 验证session是否失效，did + cpuId + androidId + imeiId
 *
 * @author Arvin Zhang
 * @date 2018/8/11 10:38
 */
@Aspect
@Order(2)
public class VerifySessionInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(VerifySessionInterceptor.class);

    @Autowired private CommonServiceApi commonServiceApi;

    @Pointcut(value = "@annotation(com.valor.vod.common.web.aop.annotation.VerifySession)")
    public void verifySession() {}

    @Around(
            value =
                    "com.valor.vod.common.web.aop.processor.VerifySessionInterceptor.verifySession()")
    public Object doVerifySession(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = getRequest(pjp);
        HttpServletResponse response = getResponse(pjp);

        BaseRequestArgs args = getArgs(pjp);
        Object proceed = pjp.proceed();

        if (Objects.nonNull(args)
                && StringUtils.isNotEmpty(args.getAppId())
                && args.getAppId().equalsIgnoreCase("mfc-kids")) {
            if (args.isAppReq()) {

                //                WebApiBaseResponse result =
                // SessionKidsServiceFactory.getSessionService().checkKidsSession(args.getAccountType(), args.getAccountId(), args.getClientSession(), null);
                //                if (result.getErrCode() != 0) {
                //                    response.setStatus(HttpCode2.SERVER_ERROR);
                //                    if (proceed instanceof ResponseStatus) {
                //                        ResponseStatus responseStatus = (ResponseStatus) proceed;
                //                        responseStatus.setStatus(HttpCode2.RET_UNAUTHORIZED,
                // HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE, "Invalid session , user is
                // not online ");
                //                    } else if (proceed instanceof WebApiResponse) {
                //                        ResponseStatus responseStatus = new
                // ResponseStatus(HttpCode2.RET_UNAUTHORIZED,
                // HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE, "Invalid session , user is
                // not online ");
                //                        return responseStatus;
                //                    }
                //
                //                    logger.info("Kids account[{}] accountType[{}] session[{}] ,
                // session is not online ", args.getAccountId(), args.getAccountType(),
                // args.getClientSession());
                //                } else {
                //                    logger.debug("Kids account[{}] accountType[{}] session[{}] ,
                // session is online ", args.getAccountId(), args.getAccountType(),
                // args.getClientSession());
                //                }

            } else {
                logger.info(
                        "Kids account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ",
                        args.getAccountId(),
                        args.getAccountType(),
                        args.getClientSession(),
                        args.isAppReq(),
                        args.getAccountType() == EAccountType.DEVICE.getCode());
            }
        } else {
            //        if (args.isAppReq() && args.getAccountType() ==
            // EAccountType.ACCOUNT.getCode()) {
            if (args.isAppReq()) {

                ApiBaseResponse result =
                        commonServiceApi.checkSession(
                                args.getAccountId(),
                                args.getAccountType(),
                                args.getClientSession(),
                                null);
                //                WebApiBaseResponse result =
                // SessionServiceFactory.getSessionService().checkSession(args.getAccountType(),
                // args.getAccountId(), args.getClientSession(), null);
                if (result.getErrCode() != 0) {
                    response.setStatus(HttpCode2.SERVER_ERROR);
                    if (proceed instanceof ResponseStatus) {
                        ResponseStatus responseStatus = (ResponseStatus) proceed;
                        responseStatus.setStatus(
                                HttpCode2.RET_UNAUTHORIZED,
                                HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE,
                                "Invalid session , user is not online ");
                    } else if (proceed instanceof WebApiResponse) {
                        ResponseStatus responseStatus =
                                new ResponseStatus(
                                        HttpCode2.RET_UNAUTHORIZED,
                                        HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE,
                                        "Invalid session , user is not online ");
                        return responseStatus;
                    }

                    logger.info(
                            "Account[{}] accountType[{}] session[{}] , session is not online ",
                            args.getAccountId(),
                            args.getAccountType(),
                            args.getClientSession());
                } else {
                    logger.debug(
                            "Account[{}] accountType[{}] session[{}] , session is online ",
                            args.getAccountId(),
                            args.getAccountType(),
                            args.getClientSession());
                }

            } else {
                logger.info(
                        "Account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ",
                        args.getAccountId(),
                        args.getAccountType(),
                        args.getClientSession(),
                        args.isAppReq(),
                        args.getAccountType() == EAccountType.DEVICE.getCode());
            }
        }
        return proceed;
    }

    private HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest) jp.getArgs()[0];
    }

    private HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse) jp.getArgs()[1];
    }

    public BaseRequestArgs getArgs(JoinPoint jp) {
        Object arg = null;
        if (jp.getArgs().length >= 3) {
            arg = jp.getArgs()[2];
            if (arg instanceof BaseRequestArgs) {
                return (BaseRequestArgs) arg;
            }
        }
        return null;
    }
}
