package com.valor.vod.common.web.configuration;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/**
 * 错误码扫描器
 *
 * @author Bruce Wu
 * @since 2023-03-06
 */
public class ErrorCodeScannerConfigurer
        implements BeanDefinitionRegistryPostProcessor, ApplicationContextAware, InitializingBean {

    private String basePackage;

    private ApplicationContext applicationContext;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.isTrue(StringUtils.hasLength(basePackage), "Error code scan package is empty");
    }

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry)
            throws BeansException {}

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory)
            throws BeansException {
        ClassPathErrorCodeScanner scanner = new ClassPathErrorCodeScanner();
        scanner.setEnvironment(applicationContext.getEnvironment());
        scanner.setResourceLoader(applicationContext);

        scanner.scan(
                StringUtils.tokenizeToStringArray(
                        this.basePackage,
                        ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS));
    }
}
