package com.valor.vod.common.web.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Vod common web properties
 *
 * @author Bruce Wu
 * @since 2023-03-09
 */
@ConfigurationProperties("vod.common.web")
public class VodCommonWebProperties implements Serializable {

    /** requestClient aop */
    private RequestClient requestClient = new RequestClient();

    /** validParameter aop */
    private ValidParameter validParameter = new ValidParameter();

    /** verifySession aop */
    private VerifySession verifySession = new VerifySession();

    /** 提取Headers headerName -> attrName */
    private Map<String, String> extractHeaders = new LinkedHashMap<>();

    public RequestClient getRequestClient() {
        return requestClient;
    }

    public void setRequestClient(RequestClient requestClient) {
        this.requestClient = requestClient;
    }

    public ValidParameter getValidParameter() {
        return validParameter;
    }

    public void setValidParameter(ValidParameter validParameter) {
        this.validParameter = validParameter;
    }

    public void setVerifySession(VerifySession verifySession) {
        this.verifySession = verifySession;
    }

    public VerifySession getVerifySession() {
        return verifySession;
    }

    public Map<String, String> getExtractHeaders() {
        return extractHeaders;
    }

    public void setExtractHeaders(Map<String, String> extractHeaders) {
        this.extractHeaders = extractHeaders;
    }

    /** RequestClient */
    public static class RequestClient {
        /** RequestClient切面是否开启 */
        private boolean enabled = true;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    /** ValidParameter */
    public static class ValidParameter {
        /** ValidParameter切面是否开启 */
        private boolean enabled = true;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    /** CommonService */
    public static class VerifySession {
        /** CommonService是否开启 */
        private boolean enabled = true;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}
