package com.valor.vod.common.web.constant;

import com.valor.vod.common.web.tools.ErrorManager;

/**
 * @author Bruce Wu
 * @since 2023-03-02
 */
public interface ErrorCode {

    /**
     * 获取项目模块
     *
     * @return projectModule
     */
    ProjectModule getProjectModule();

    /**
     * 获取 Http 状态码
     *
     * @see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Status">HTTP状态码</a>
     * @return http code
     */
    int getHttpCode();

    /**
     * 获取错误码
     *
     * @return code
     */
    String getCode();

    /**
     * 获取错误描述
     *
     * @return desc
     */
    String getDesc();

    /**
     * 获取响应错误码 0.0.00000
     *
     * @return resp code
     */
    default String getRespCode() {
        return ErrorManager.getRespCode(this);
    }
}
