package com.valor.vod.common.web.constant;

import com.valor.vod.api.model.constant.response.HttpCode2;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 系统级公用错误码
 *
 * @author Bruce Wu
 * @since 2023-03-03
 */
@Getter
public enum SystemErrorCodes implements ErrorCode {
    /** OK */
    OK(SystemProjectModules.COMMON, 200, "00000", "ok"),

    /** 属性未找到 */
    ATTR_NOT_FOUND(SystemProjectModules.COMMON, 500, "99996", "Attribute not found"),
    /** 未授权 */
    UNAUTHORIZED(SystemProjectModules.COMMON, 401, "99997", "Please login"),
    /** 参数非法 */
    PARAM_INVALID(SystemProjectModules.COMMON, 400, "99998", "Invalid parameter"),
    /** 参数非法 */
    SESSION_OFFLINE(SystemProjectModules.COMMON, 400, "225", "Invalid session , user is not online"),
    /** 系统异常 */
    SYSTEM_ERROR(SystemProjectModules.COMMON, 500, "99999", "Internal Server Error"),
    ;

    private final ProjectModule projectModule;

    private final int httpCode;

    private final String code;

    private final String desc;

    SystemErrorCodes(ProjectModule projectModule, int httpCode, String code, String desc) {
        this.projectModule = projectModule;
        this.httpCode = httpCode;
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, SystemErrorCodes> RET_CODE_MAP = new HashMap<>();

    static {
        RET_CODE_MAP.put(HttpCode2.OK, SystemErrorCodes.OK);
        RET_CODE_MAP.put(HttpCode2.RET_UNAUTHORIZED, SystemErrorCodes.UNAUTHORIZED);
        RET_CODE_MAP.put(HttpCode2.RET_INVALID_PARAM, SystemErrorCodes.PARAM_INVALID);
        RET_CODE_MAP.put(HttpCode2.RET_SYS_EXCEPTION, SystemErrorCodes.SYSTEM_ERROR);
    }

    public static boolean contains(ErrorCode errorCode) {
        for (SystemErrorCodes e : SystemErrorCodes.values()) {
            if (Objects.equals(e, errorCode)) {
                return true;
            }
        }
        return false;
    }

    public static SystemErrorCodes getByRetCode(int retCode) {
        return RET_CODE_MAP.getOrDefault(retCode, SystemErrorCodes.SYSTEM_ERROR);
    }
}
