package com.valor.vod.common.web.constant;

import lombok.Getter;

import java.util.Objects;

/**
 * 公用模块
 *
 * @author Bruce Wu
 * @since 2023-03-03
 */
@Getter
public enum SystemProjectModules implements ProjectModule {
    /** COMMON */
    COMMON("", ""),
    ;
    /** projectCode */
    private final String projectCode;
    /** Module code */
    private final String moduleCode;

    SystemProjectModules(String projectCode, String moduleCode) {
        this.projectCode = projectCode;
        this.moduleCode = moduleCode;
    }

    @Override
    public String getProjectName() {
        return "system";
    }

    @Override
    public String getModuleName() {
        return "system";
    }

    public static boolean contains(ProjectModule projectModule) {
        for (SystemProjectModules e : SystemProjectModules.values()) {
            if (Objects.equals(e, projectModule)) {
                return true;
            }
        }
        return false;
    }
}
