package com.valor.vod.common.web.constant;

import com.valor.vod.common.constant.ConstantPool;
import com.valor.vod.common.tools.http.HttpConstant;

import java.util.Objects;

/**
 * Vod http 属性
 *
 * @author Bruce Wu
 * @date 2023-03-15
 */
public class VodHttpAttr {

    private static final ConstantPool<VodHttpAttr> POOL =
            new ConstantPool<VodHttpAttr>() {
                @Override
                protected VodHttpAttr newConstant(String name) {
                    return new VodHttpAttr(name);
                }
            };

    /** Token -> token */
    public static final VodHttpAttr TOKEN = valueOf(HttpConstant.HTTP_REQ_ATTR_TOKEN);
    /** Token -> AccountID */
    public static final VodHttpAttr UID = valueOf(HttpConstant.HTTP_REQ_ATTR_ACCOUNT_ID);
    /** Token -> AccountId */
    public static final VodHttpAttr ACCOUNT_ID = UID;
    /** Token -> 账户类型 */
    public static final VodHttpAttr ACCOUNT_TYPE = valueOf(HttpConstant.HTTP_ARG_ACCOUNT_TYPE);
    /** Token -> DID */
    public static final VodHttpAttr DID = valueOf(HttpConstant.HTTP_REQ_ATTR_DID);
    /** Token DID2 */
    public static final VodHttpAttr DID2 = valueOf(HttpConstant.HTTP_REQ_ATTR_UID);
    /** Token -> TS */
    public static final VodHttpAttr TS = valueOf(HttpConstant.HTTP_REQ_ATTR_TS);
    /** Token -> UPROP */
    public static final VodHttpAttr UPROP = valueOf(HttpConstant.HTTP_REQ_ATTR_UPROP);
    /** Token -> clientSession */
    public static final VodHttpAttr CLIENT_SESSION = valueOf(HttpConstant.HTTP_ARG_CLIENT_SESSION);

    /** client ip */
    public static final VodHttpAttr CLIENT_IP = valueOf(HttpConstant.HTTP_REQ_ATTR_CLIENT_IP);
    /** 语言 */
    public static final VodHttpAttr LANGUAGE = valueOf(HttpConstant.HTTP_REQ_ATTR_LANG);
    /** 多租Vno */
    public static final VodHttpAttr VNO = valueOf(HttpConstant.HTTP_REQ_ATTR_VNO);
    /** 多租Brand */
    public static final VodHttpAttr BRAND = valueOf(HttpConstant.HTTP_REQ_ATTR_BRAND);
    /** Appid */
    public static final VodHttpAttr APP_ID = valueOf(HttpConstant.HTTP_REQ_ATTR_APP_ID);
    /** AppVer */
    public static final VodHttpAttr APP_VER = valueOf(HttpConstant.HTTP_REQ_ATTR_APP_VER);

    private final String name;

    public VodHttpAttr(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VodHttpAttr that = (VodHttpAttr) o;
        return Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    public static VodHttpAttr valueOf(String name) {
        return POOL.valueOf(name);
    }
}
