package com.valor.vod.common.web.constant;

/**
 * vod http headers
 *
 * @author Bruce Wu
 * @date 2023-03-15
 */
public enum VodHttpHeader {

    /** 多租Vno */
    VOD_VNO("Vod-Vno", VodHttpAttr.VNO),
    /** 多租Brand */
    VOD_BRAND("Vod-Brand", VodHttpAttr.BRAND),
    /** appId */
    VOD_APP_ID("Vod-AppId", VodHttpAttr.APP_ID),
    /** app版本号 */
    VOD_APP_VER("Vod-AppVer", VodHttpAttr.APP_VER),

    /** Token -> 用户Token */
    VOD_TOKEN("Vod-Token", VodHttpAttr.TOKEN),
    /** Token -> 账户ID */
    VOD_UID("Vod-Uid", VodHttpAttr.UID),
    /** Token -> 账户类型 */
    VOD_ACCOUNT_TYPE("Vod-AccountType", VodHttpAttr.ACCOUNT_TYPE),
    /** Token -> Did */
    VOD_DID("Vod-Did", VodHttpAttr.DID),
    /** Token -> Did2 */
    VOD_DID2("Vod-Did2", VodHttpAttr.DID2),
    /** Token - ts */
    VOD_TS("Vod-Ts", VodHttpAttr.TS),
    /** Token - UProp */
    VOD_UPROP("Vod-UProp", VodHttpAttr.UPROP),
    /** Token - clientSession */
    VOD_CLIENT_SESSION("Vod-ClientSession", VodHttpAttr.CLIENT_SESSION),
    ;
    /** http请求头名称 */
    private final String headerName;
    /** 对应的属性 */
    private final VodHttpAttr attr;

    VodHttpHeader(String headerName, VodHttpAttr attr) {
        this.headerName = headerName;
        this.attr = attr;
    }

    public String getHeaderName() {
        return headerName;
    }

    public VodHttpAttr getAttr() {
        return attr;
    }
}
