package com.valor.vod.common.web.crypt;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.api.exception.ApiException;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.common.web.crypt.model.ApiCryptMsg;

import common.config.tools.config.ConfigTools3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Created by Frank.Huang on 2017/5/16. */
public class CryptMsgTools {
    private static final Logger logger = LoggerFactory.getLogger(CryptMsgTools.class);
    private static final String ARG_AES_KEY_DEFAULT = "wqlnDJADUFnNRUn0fj2CXA";
    private static String CRYPT_ARG_AES_CONFIG_KEY = "mfc.api.arg.aes.key";
    private static String CRYPT_ARG_JAQ_CONFIG_KEY = "mfc.api.arg.jaq.key";
    private static String JAQ_APP_KEY_DEFAULT = "8ff9f0db-6f7b-4492-98c1-8226f81956eb";

    public static String decryptArg(String prot, String msg, String signature) throws Exception {
        if (Strings.isNullOrEmpty(msg)) {
            logger.error("Decrypt msg is empty");
            return "";
        }
        try {
            if (ApiCryptMsg.PROT_3.equals(prot))
                return AESUtils.decrypt(
                        msg, ConfigTools3.getString(CRYPT_ARG_AES_CONFIG_KEY, ARG_AES_KEY_DEFAULT));
            else if (ApiCryptMsg.PROT_4.equals(prot)) {
                boolean checked =
                        JaqSecurity.checkSign(
                                msg,
                                ConfigTools3.getString(
                                        CRYPT_ARG_JAQ_CONFIG_KEY, JAQ_APP_KEY_DEFAULT),
                                signature);
                if (!checked)
                    throw new ApiException(
                            HttpCode2.RET_INVALID_PARAM,
                            HttpCode2.ERR_ARG_DECRYPT_SIGNATURE_EX,
                            "Args decrypt exception.");
                byte[] decodeBytes =
                        JaqSecurity.decrypt(
                                msg.getBytes(),
                                ConfigTools3.getString(
                                        CRYPT_ARG_JAQ_CONFIG_KEY, JAQ_APP_KEY_DEFAULT));
                if (decodeBytes == null) return "";
                return new String(decodeBytes);
            } else if (ApiCryptMsg.PROT_5.equals(prot)) {
                boolean checked = IjiamiSecurity.checkSign(msg, signature);
                if (!checked)
                    throw new ApiException(
                            HttpCode2.RET_INVALID_PARAM,
                            HttpCode2.ERR_ARG_DECRYPT_SIGNATURE_EX,
                            "Args decrypt exception.");
                String decodeString = IjiamiSecurity.decryptString(msg);
                return decodeString;
            } else
                throw new ApiException(
                        HttpCode2.RET_INVALID_PARAM,
                        HttpCode2.ERR_ARG_NULL_EX,
                        "Args decrypt exception.");
        } catch (Exception e) {
            logger.error("Decode arg exception:{}", e);
            if (e instanceof ApiException) throw e;
            else
                throw new ApiException(
                        HttpCode2.RET_INVALID_PARAM,
                        HttpCode2.ERR_ARG_DECRYPT_EX,
                        "Args decrypt exception.");
        }
    }

    public static String encryptMsg(String prot, String msg) {
        if (Strings.isNullOrEmpty(msg)) {
            logger.error("Encrypt msg is empty");
            return "";
        }
        try {
            if (ApiCryptMsg.PROT_3.equals(prot))
                return AESUtils.encrypt(
                        msg, ConfigTools3.getString(CRYPT_ARG_AES_CONFIG_KEY, ARG_AES_KEY_DEFAULT));
            else if (ApiCryptMsg.PROT_4.equals(prot)) {
                return JaqSecurity.encrypt(
                        msg, ConfigTools3.getString(CRYPT_ARG_JAQ_CONFIG_KEY, JAQ_APP_KEY_DEFAULT));
            } else if (ApiCryptMsg.PROT_5.equals(prot)) {
                return IjiamiSecurity.encryptString(msg);
            } else return "";
        } catch (Exception e) {
            logger.error("Encrypt arg exception:{}", e);
            return "";
        }
    }

    public static String encryptMsg(String prot, byte[] msg) {
        return encryptMsg(prot, new String(msg));
    }

    public static String getSign(String prot, String msg) {
        try {
            if (ApiCryptMsg.PROT_4.equals(prot)) {
                return JaqSecurity.sign(
                        msg, ConfigTools3.getString(CRYPT_ARG_JAQ_CONFIG_KEY, JAQ_APP_KEY_DEFAULT));
            } else if (ApiCryptMsg.PROT_5.equals(prot)) {
                return IjiamiSecurity.sign(msg);
            } else return "";
        } catch (Exception e) {
            logger.error("Sign msg exception:{}", e);
            return "";
        }
    }
}
