package com.valor.vod.common.web.filter.sso;

import com.google.common.collect.ImmutableMap;
import com.valor.vod.common.tools.type.NumberTools;

import java.util.Map;

public class TokenFiledTools {
    private static final Map<Integer, Class> fieldTypeMapping =
            ImmutableMap.<Integer, Class>builder()
                    .put(AuthTokenFiled.SIGN.ordinal(), Long.class)
                    .put(AuthTokenFiled.VERSION.ordinal(), Integer.class)
                    .put(AuthTokenFiled.CREATE_TIMESTAMP.ordinal(), Long.class)
                    .put(AuthTokenFiled.EXPIRE_TIMESTAMP.ordinal(), Long.class)
                    .put(AuthTokenFiled.ACCOUNT_TYPE.ordinal(), Integer.class)
                    .put(AuthTokenFiled.ACCOUNT_ID.ordinal(), Long.class)
                    .put(AuthTokenFiled.SUB_ACCOUNT_ID.ordinal(), Long.class)
                    .put(AuthTokenFiled.PROPERTIES.ordinal(), Long.class)
                    .put(AuthTokenFiled.DID.ordinal(), String.class)
                    .put(AuthTokenFiled.DEVICE_ID.ordinal(), Long.class)
                    .put(AuthTokenFiled.CLIENT_TYPE.ordinal(), Integer.class)
                    .put(AuthTokenFiled.CLIENT_SESSION.ordinal(), String.class)
                    .put(AuthTokenFiled.ECHO_STR.ordinal(), String.class)
                    .put(AuthTokenFiled.PRODUCT_ID.ordinal(), Long.class)
                    .put(AuthTokenFiled.ROOT_NODE_ID.ordinal(), Long.class)
                    .build();

    private static Class getFieldType(int fieldName) {
        return fieldTypeMapping.getOrDefault(fieldName, null);
    }

    public static Object getFieldValue(int fieldName, String fieldValue) {
        Class valueType = getFieldType(fieldName);
        if (valueType == null) {
            return null;
        }

        if (valueType == String.class) {
            return fieldValue;
        }

        if (valueType == Long.class) {
            return NumberTools.nullToZero((Long) NumberTools.toNumeric(valueType, fieldValue));
        }

        if (valueType == Integer.class) {
            return NumberTools.nullToZero((Integer) NumberTools.toNumeric(valueType, fieldValue));
        }

        return null;
    }
}
